/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.impl.BulkLoad;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class BackupHFileCleaner
extends BaseHFileCleanerDelegate
implements Abortable {
    private static final Logger LOG = LoggerFactory.getLogger(BackupHFileCleaner.class);
    private boolean stopped = false;
    private boolean aborted = false;
    private Connection connection;
    private volatile long previousCleaningCompletionTimestamp = 0L;

    public void postClean() {
        this.previousCleaningCompletionTimestamp = EnvironmentEdgeManager.currentTime();
    }

    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        if (this.stopped) {
            return Collections.emptyList();
        }
        HashSet<String> hfileFilenames = new HashSet<String>();
        try (BackupSystemTable tbl = new BackupSystemTable(this.connection);){
            Set<TableName> tablesIncludedInBackups = this.fetchFullyBackedUpTables(tbl);
            for (BulkLoad bulkLoad : tbl.readBulkloadRows(tablesIncludedInBackups)) {
                hfileFilenames.add(new Path(bulkLoad.getHfilePath()).getName());
            }
            LOG.debug("Found {} unique HFile filenames registered as bulk loads.", (Object)hfileFilenames.size());
        }
        catch (IOException ioe) {
            LOG.error("Failed to read registered bulk load references from backup system table, marking all files as non-deletable.", (Throwable)ioe);
            return Collections.emptyList();
        }
        long recentFileThreshold = this.previousCleaningCompletionTimestamp;
        return Iterables.filter(files, file -> {
            if (file.getModificationTime() > recentFileThreshold) {
                LOG.debug("Preventing deletion due to timestamp: {}", (Object)file.getPath().toString());
                return false;
            }
            String hfile = file.getPath().getName();
            if (hfileFilenames.contains(hfile)) {
                LOG.debug("Preventing deletion due to bulk load registration in backup system table: {}", (Object)file.getPath().toString());
                return false;
            }
            LOG.debug("OK to delete: {}", (Object)file.getPath().toString());
            return true;
        });
    }

    protected Set<TableName> fetchFullyBackedUpTables(BackupSystemTable tbl) throws IOException {
        return tbl.getTablesIncludedInBackups();
    }

    public boolean isFileDeletable(FileStatus fStat) {
        throw new IllegalStateException("This method should not be called");
    }

    public void setConf(Configuration config) {
        this.connection = null;
        try {
            this.connection = ConnectionFactory.createConnection((Configuration)config);
        }
        catch (IOException ioe) {
            LOG.error("Couldn't establish connection", (Throwable)ioe);
        }
    }

    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException ioe) {
                LOG.debug("Got IOException when closing connection", (Throwable)ioe);
            }
        }
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void abort(String why, Throwable e) {
        LOG.warn("Aborting ReplicationHFileCleaner because {}", (Object)why, (Object)e);
        this.aborted = true;
        this.stop(why);
    }

    public boolean isAborted() {
        return this.aborted;
    }
}

