/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.windows;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum OpenFlags implements Constant
{
    O_RDONLY(0L),
    O_WRONLY(1L),
    O_RDWR(2L),
    O_ACCMODE(3L),
    O_APPEND(8L),
    O_CREAT(256L),
    O_TRUNC(512L),
    O_EXCL(1024L),
    O_BINARY(32768L);

    private final long value;
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 32768L;

    private OpenFlags(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<OpenFlags, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<OpenFlags, String> generateTable() {
            EnumMap<OpenFlags, String> map2 = new EnumMap<OpenFlags, String>(OpenFlags.class);
            map2.put(O_RDONLY, "O_RDONLY");
            map2.put(O_WRONLY, "O_WRONLY");
            map2.put(O_RDWR, "O_RDWR");
            map2.put(O_ACCMODE, "O_ACCMODE");
            map2.put(O_APPEND, "O_APPEND");
            map2.put(O_CREAT, "O_CREAT");
            map2.put(O_TRUNC, "O_TRUNC");
            map2.put(O_EXCL, "O_EXCL");
            map2.put(O_BINARY, "O_BINARY");
            return map2;
        }
    }
}

