/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.joni;

import org.apache.hadoop.hbase.shaded.org.joni.CaptureTreeNode;
import org.apache.hadoop.hbase.shaded.org.joni.MultiRegion;
import org.apache.hadoop.hbase.shaded.org.joni.SingleRegion;

public abstract class Region {
    static final int REGION_NOTPOS = -1;
    protected CaptureTreeNode historyRoot;

    public static Region newRegion(int num) {
        if (num == 1) {
            return new SingleRegion(num);
        }
        return new MultiRegion(num);
    }

    public static Region newRegion(int begin, int end) {
        return new SingleRegion(begin, end);
    }

    public abstract Region clone();

    public abstract int getNumRegs();

    public abstract int getBeg(int var1);

    public abstract int setBeg(int var1, int var2);

    public abstract int getEnd(int var1);

    public abstract int setEnd(int var1, int var2);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Region: \n");
        for (int i = 0; i < this.getNumRegs(); ++i) {
            sb.append(" " + i + ": (" + this.getBeg(i) + "-" + this.getEnd(i) + ")");
        }
        return sb.toString();
    }

    CaptureTreeNode getCaptureTree() {
        return this.historyRoot;
    }

    CaptureTreeNode setCaptureTree(CaptureTreeNode ctn) {
        this.historyRoot = ctn;
        return this.historyRoot;
    }

    abstract void clear();
}

