/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.net.UrlEscapers;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;

final class ServletUtils {
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');
    private static final Joiner SLASH_JOINER = Joiner.on((char)'/');

    private ServletUtils() {
    }

    static String getContextRelativePath(HttpServletRequest request) {
        if (request != null) {
            String contextPath = request.getContextPath();
            String requestURI = request.getRequestURI();
            if (contextPath.length() < requestURI.length()) {
                String suffix = requestURI.substring(contextPath.length());
                return ServletUtils.normalizePath(suffix);
            }
            if (requestURI.trim().length() > 0 && contextPath.length() == requestURI.length()) {
                return "/";
            }
        }
        return null;
    }

    static String normalizePath(String path) {
        StringBuilder sb = new StringBuilder(path.length());
        int queryStart = path.indexOf(63);
        String query = null;
        if (queryStart != -1) {
            query = path.substring(queryStart);
            path = path.substring(0, queryStart);
        }
        ArrayList<String> segments = new ArrayList<String>();
        for (String segment : SLASH_SPLITTER.split((CharSequence)path)) {
            String normalized = UrlEscapers.urlPathSegmentEscaper().escape(ServletUtils.lenientDecode(segment, Charsets.UTF_8, false));
            if (".".equals(normalized)) continue;
            if ("..".equals(normalized)) {
                if (segments.size() <= 1) continue;
                segments.remove(segments.size() - 1);
                continue;
            }
            segments.add(normalized);
        }
        SLASH_JOINER.appendTo(sb, segments);
        if (query != null) {
            sb.append(query);
        }
        return sb.toString();
    }

    private static String lenientDecode(String string, Charset encoding, boolean decodePlus) {
        int firstPercentPos;
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)encoding);
        if (decodePlus) {
            string = string.replace('+', ' ');
        }
        if ((firstPercentPos = string.indexOf(37)) < 0) {
            return string;
        }
        ByteAccumulator accumulator = new ByteAccumulator(string.length(), encoding);
        StringBuilder builder = new StringBuilder(string.length());
        if (firstPercentPos > 0) {
            builder.append(string, 0, firstPercentPos);
        }
        for (int srcPos = firstPercentPos; srcPos < string.length(); ++srcPos) {
            char c = string.charAt(srcPos);
            if (c < '\u0080') {
                boolean processed = false;
                if (c == '%' && string.length() >= srcPos + 3) {
                    String hex = string.substring(srcPos + 1, srcPos + 3);
                    try {
                        int encoded = Integer.parseInt(hex, 16);
                        if (encoded >= 0) {
                            accumulator.append((byte)encoded);
                            srcPos += 2;
                            processed = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (processed) continue;
                if (accumulator.isEmpty()) {
                    builder.append(c);
                    continue;
                }
                accumulator.append((byte)c);
                continue;
            }
            accumulator.dumpTo(builder);
            builder.append(c);
        }
        accumulator.dumpTo(builder);
        return builder.toString();
    }

    private static class ByteAccumulator {
        private byte[] bytes;
        private int length;
        private final Charset encoding;

        ByteAccumulator(int capacity, Charset encoding) {
            this.bytes = new byte[Math.min(16, capacity)];
            this.encoding = encoding;
        }

        void append(byte b) {
            this.ensureCapacity(this.length + 1);
            this.bytes[this.length++] = b;
        }

        void dumpTo(StringBuilder dest) {
            if (this.length != 0) {
                dest.append(new String(this.bytes, 0, this.length, this.encoding));
                this.length = 0;
            }
        }

        boolean isEmpty() {
            return this.length == 0;
        }

        private void ensureCapacity(int minCapacity) {
            int cap = this.bytes.length;
            if (cap >= minCapacity) {
                return;
            }
            int newCapacity = cap + (cap >> 1);
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
    }
}

