/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hive.hplsql.Column;
import org.apache.hive.hplsql.ColumnDefinition;
import org.apache.hive.hplsql.ColumnMap;
import org.apache.hive.hplsql.Var;

public class Row {
    private final ColumnMap colMap = new ColumnMap();

    public Row() {
    }

    Row(Row row) {
        for (Column c : row.colMap.columns()) {
            this.addColumnDefinition(c.getName(), c.getType());
        }
    }

    public void addColumnDefinition(String name, String type) {
        this.colMap.add(new Column(name, type, null));
    }

    public void addColumn(String name, String type, Var value) {
        Column column = new Column(name, type, value);
        this.colMap.add(column);
    }

    public String getType(String name) {
        Column column = this.colMap.get(name);
        return column != null ? column.getType() : null;
    }

    public Var getValue(int i) {
        return this.colMap.at(i).getValue();
    }

    Var getValue(String name) {
        Column column = this.colMap.get(name);
        return column != null ? column.getValue() : null;
    }

    List<Column> getColumns() {
        return this.colMap.columns();
    }

    public Column getColumn(int i) {
        return this.colMap.at(i);
    }

    int size() {
        return this.colMap.size();
    }

    public List<ColumnDefinition> columnDefinitions() {
        return this.getColumns().stream().map(Column::definition).collect(Collectors.toList());
    }
}

