/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.HCatSplit;
import org.apache.hive.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hive.hcatalog.mapreduce.ProgressReporter;
import org.apache.hive.hcatalog.mapreduce.StorerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalUtil {
    private static final Logger LOG = LoggerFactory.getLogger(InternalUtil.class);

    InternalUtil() {
    }

    static StorerInfo extractStorerInfo(StorageDescriptor sd, Map<String, String> properties) throws IOException {
        Properties hcatProperties = new Properties();
        for (String string : properties.keySet()) {
            hcatProperties.put(string, properties.get(string));
        }
        for (Map.Entry entry : sd.getSerdeInfo().getParameters().entrySet()) {
            hcatProperties.put(entry.getKey(), entry.getValue());
        }
        return new StorerInfo(sd.getInputFormat(), sd.getOutputFormat(), sd.getSerdeInfo().getSerializationLib(), properties.get("storage_handler"), hcatProperties);
    }

    static StructObjectInspector createStructObjectInspector(HCatSchema outputSchema) throws IOException {
        if (outputSchema == null) {
            throw new IOException("Invalid output schema specified");
        }
        ArrayList<ObjectInspector> fieldInspectors = new ArrayList<ObjectInspector>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (HCatFieldSchema hcatFieldSchema : outputSchema.getFields()) {
            TypeInfo type = TypeInfoUtils.getTypeInfoFromTypeString((String)hcatFieldSchema.getTypeString());
            fieldNames.add(hcatFieldSchema.getName());
            fieldInspectors.add(InternalUtil.getObjectInspector(type));
        }
        StandardStructObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldInspectors);
        return structInspector;
    }

    private static ObjectInspector getObjectInspector(TypeInfo type) throws IOException {
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveType = (PrimitiveTypeInfo)type;
                return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)primitiveType);
            }
            case MAP: {
                MapTypeInfo mapType = (MapTypeInfo)type;
                StandardMapObjectInspector mapInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)InternalUtil.getObjectInspector(mapType.getMapKeyTypeInfo()), (ObjectInspector)InternalUtil.getObjectInspector(mapType.getMapValueTypeInfo()));
                return mapInspector;
            }
            case LIST: {
                ListTypeInfo listType = (ListTypeInfo)type;
                StandardListObjectInspector listInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)InternalUtil.getObjectInspector(listType.getListElementTypeInfo()));
                return listInspector;
            }
            case STRUCT: {
                StructTypeInfo structType = (StructTypeInfo)type;
                List fieldTypes = structType.getAllStructFieldTypeInfos();
                ArrayList<ObjectInspector> fieldInspectors = new ArrayList<ObjectInspector>();
                for (TypeInfo fieldType : fieldTypes) {
                    fieldInspectors.add(InternalUtil.getObjectInspector(fieldType));
                }
                StandardStructObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)structType.getAllStructFieldNames(), fieldInspectors);
                return structInspector;
            }
        }
        throw new IOException("Unknown field schema type");
    }

    static void initializeOutputSerDe(AbstractSerDe serDe, Configuration conf, OutputJobInfo jobInfo) throws SerDeException {
        serDe.initialize(conf, InternalUtil.getSerdeProperties(jobInfo.getTableInfo(), jobInfo.getOutputSchema()), null);
    }

    static void initializeDeserializer(Deserializer deserializer, Configuration conf, HCatTableInfo info, HCatSchema schema) throws SerDeException {
        Properties props = InternalUtil.getSerdeProperties(info, schema);
        LOG.info("Initializing " + deserializer.getClass().getName() + " with properties " + String.valueOf(props));
        AbstractSerDe serDe = (AbstractSerDe)deserializer;
        serDe.initialize(conf, props, null);
    }

    private static Properties getSerdeProperties(HCatTableInfo info, HCatSchema s) throws SerDeException {
        Properties props = new Properties();
        List<FieldSchema> fields = HCatUtil.getFieldSchemaList(s.getFields());
        props.setProperty("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fields));
        props.setProperty("column.name.delimiter", MetaStoreUtils.getColumnNameDelimiter(fields));
        props.setProperty("columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fields));
        props.setProperty("columns.comments", MetaStoreUtils.getColumnCommentsFromFieldSchema(fields));
        props.setProperty("serialization.null.format", "\\N");
        props.setProperty("serialization.format", "1");
        props.putAll((Map<?, ?>)info.getStorerInfo().getProperties());
        return props;
    }

    static Reporter createReporter(TaskAttemptContext context) {
        return new ProgressReporter(context);
    }

    public static HCatSplit castToHCatSplit(InputSplit split) throws IOException {
        if (split instanceof HCatSplit) {
            return (HCatSplit)split;
        }
        throw new IOException("Split must be " + HCatSplit.class.getName() + " but found " + split.getClass().getName());
    }

    static Map<String, String> createPtnKeyValueMap(Table table, Partition ptn) throws IOException {
        List values = ptn.getValues();
        if (values.size() != table.getPartitionKeys().size()) {
            throw new IOException("Partition values in partition inconsistent with table definition, table " + table.getTableName() + " has " + table.getPartitionKeys().size() + " partition keys, partition has " + values.size() + "partition values");
        }
        HashMap<String, String> ptnKeyValues = new HashMap<String, String>();
        int i = 0;
        for (FieldSchema schema : table.getPartitionKeys()) {
            ptnKeyValues.put(schema.getName().toLowerCase(), (String)values.get(i));
            ++i;
        }
        return ptnKeyValues;
    }
}

