/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.LlapCacheHydration;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.io.api.LlapIo;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.registry.RegistryUtilities;
import org.apache.hive.common.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLlapCacheHydration
implements LlapCacheHydration {
    private static final Logger LOG = LoggerFactory.getLogger(BasicLlapCacheHydration.class);
    private Configuration conf;
    private String savePath;
    @VisibleForTesting
    LlapIo llapIo;

    @Override
    public void load() {
        this.loadCacheContent();
    }

    @Override
    public void save() {
        this.saveCacheContent();
    }

    @Override
    public void init() {
        ShutdownHookManager.addShutdownHook(() -> this.save());
        this.initSavePath();
        if (this.llapIo == null) {
            this.llapIo = LlapProxy.getIo();
        }
    }

    @VisibleForTesting
    void initSavePath() {
        if (this.savePath == null) {
            String dir = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_HYDRATION_SAVE_DIR);
            String name = RegistryUtilities.getCanonicalHostName();
            if (dir != null && name != null) {
                this.createDirIfNotExists(dir);
                this.savePath = dir + "/" + name.hashCode() + ".cache";
            }
        }
    }

    private void createDirIfNotExists(String dir) {
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdir();
        }
    }

    private void saveCacheContent() {
        LlapDaemonProtocolProtos.CacheEntryList entryList;
        if (this.llapIo != null && this.savePath != null && !(entryList = this.llapIo.fetchCachedContentInfo()).getEntriesList().isEmpty()) {
            try (FileOutputStream fos = new FileOutputStream(this.savePath);){
                entryList.writeTo((OutputStream)fos);
                LOG.debug("Llap cache content info saved: " + this.savePath);
            }
            catch (IOException ex) {
                LOG.warn("Couldn't save llap cache content info.", (Throwable)ex);
            }
        }
    }

    private void loadCacheContent() {
        File file;
        if (this.llapIo != null && this.savePath != null && (file = new File(this.savePath)).exists()) {
            try (FileInputStream fis = new FileInputStream(file);){
                LlapDaemonProtocolProtos.CacheEntryList entryList = LlapDaemonProtocolProtos.CacheEntryList.parseFrom((InputStream)fis);
                if (!entryList.getEntriesList().isEmpty()) {
                    this.llapIo.loadDataIntoCache(entryList);
                    LOG.debug("Llap cache content info loaded: " + this.savePath);
                    file.delete();
                }
            }
            catch (IOException ex) {
                LOG.warn("Couldn't load llap cache.", (Throwable)ex);
            }
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

