/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.llap.cache.FileCache;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hive.common.util.Ref;

abstract class FileCacheCleanupThread<T>
extends Thread {
    private final long approxCleanupIntervalSec;
    private final AtomicInteger newEvictions;
    private final ConcurrentHashMap<Object, FileCache<T>> fileMap;

    public FileCacheCleanupThread(String name, ConcurrentHashMap<Object, FileCache<T>> fileMap, AtomicInteger newEvictions, long cleanupInterval) {
        super(name);
        this.fileMap = fileMap;
        this.newEvictions = newEvictions;
        this.approxCleanupIntervalSec = cleanupInterval;
        this.setDaemon(true);
        this.setPriority(1);
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.doOneCleanupRound();
            }
        }
        catch (InterruptedException ex) {
            LlapIoImpl.LOG.warn("Cleanup thread has been interrupted");
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            LlapIoImpl.LOG.error("Cleanup has failed; the thread will now exit", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOneCleanupRound() throws InterruptedException {
        int evictionsSinceLast;
        while ((evictionsSinceLast = this.newEvictions.getAndSet(0)) <= 0) {
            AtomicInteger atomicInteger = this.newEvictions;
            synchronized (atomicInteger) {
                this.newEvictions.wait(10000L);
            }
        }
        long endTime = System.nanoTime() + this.approxCleanupIntervalSec * 1000000000L;
        int leftToCheck = 0;
        for (FileCache<T> fc : this.fileMap.values()) {
            leftToCheck += this.getCacheSize(fc);
        }
        Iterator<Map.Entry<Object, FileCache<T>>> iter = this.fileMap.entrySet().iterator();
        Ref isPastEndTime = Ref.from((Object)false);
        while (iter.hasNext()) {
            FileCache<T> fc = iter.next().getValue();
            if (!fc.incRef()) {
                throw new AssertionError((Object)"Something other than cleanup is removing elements from map");
            }
            leftToCheck = this.cleanUpOneFileCache(fc, leftToCheck, endTime, (Ref<Boolean>)isPastEndTime);
            if (this.getCacheSize(fc) > 0) {
                fc.decRef();
                continue;
            }
            if (!fc.startEvicting()) continue;
            if (this.getCacheSize(fc) == 0) {
                fc.commitEvicting();
                iter.remove();
                continue;
            }
            fc.abortEvicting();
        }
    }

    protected abstract int getCacheSize(FileCache<T> var1);

    protected abstract int cleanUpOneFileCache(FileCache<T> var1, int var2, long var3, Ref<Boolean> var5) throws InterruptedException;
}

