/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.system;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;

public class TimeSettingIterator
implements InterruptibleIterator {
    private SortedKeyValueIterator<Key, Value> source;
    private long time;
    private Range range;

    public TimeSettingIterator(SortedKeyValueIterator<Key, Value> source, long time) {
        this.source = source;
        this.time = time;
    }

    @Override
    public Key getTopKey() {
        Key key = this.source.getTopKey();
        key.setTimestamp(this.time);
        return key;
    }

    @Override
    public void setInterruptFlag(AtomicBoolean flag) {
        ((InterruptibleIterator)this.source).setInterruptFlag(flag);
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new TimeSettingIterator(this.source.deepCopy(env), this.time);
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
    }

    @Override
    public boolean hasTop() {
        return this.source.hasTop() && !this.range.afterEndKey(this.getTopKey());
    }

    @Override
    public void next() throws IOException {
        this.source.next();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        Range seekRange = IteratorUtil.maximizeStartKeyTimeStamp(range);
        seekRange = IteratorUtil.minimizeEndKeyTimeStamp(seekRange);
        this.source.seek(seekRange, columnFamilies, inclusive);
        this.range = range;
        while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
            this.next();
        }
    }

    @Override
    public Value getTopValue() {
        return this.source.getTopValue();
    }
}

