/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.master.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.master.thrift.BulkImportStatus;
import org.apache.accumulo.core.master.thrift.RecoveryStatus;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TabletServerStatus
implements TBase<TabletServerStatus, _Fields>,
Serializable,
Cloneable,
Comparable<TabletServerStatus> {
    private static final TStruct STRUCT_DESC = new TStruct("TabletServerStatus");
    private static final TField TABLE_MAP_FIELD_DESC = new TField("tableMap", 13, 1);
    private static final TField LAST_CONTACT_FIELD_DESC = new TField("lastContact", 10, 2);
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 3);
    private static final TField OS_LOAD_FIELD_DESC = new TField("osLoad", 4, 5);
    private static final TField HOLD_TIME_FIELD_DESC = new TField("holdTime", 10, 7);
    private static final TField LOOKUPS_FIELD_DESC = new TField("lookups", 10, 8);
    private static final TField INDEX_CACHE_HITS_FIELD_DESC = new TField("indexCacheHits", 10, 10);
    private static final TField INDEX_CACHE_REQUEST_FIELD_DESC = new TField("indexCacheRequest", 10, 11);
    private static final TField DATA_CACHE_HITS_FIELD_DESC = new TField("dataCacheHits", 10, 12);
    private static final TField DATA_CACHE_REQUEST_FIELD_DESC = new TField("dataCacheRequest", 10, 13);
    private static final TField LOG_SORTS_FIELD_DESC = new TField("logSorts", 15, 14);
    private static final TField FLUSHS_FIELD_DESC = new TField("flushs", 10, 15);
    private static final TField SYNCS_FIELD_DESC = new TField("syncs", 10, 16);
    private static final TField BULK_IMPORTS_FIELD_DESC = new TField("bulkImports", 15, 17);
    private static final TField RESPONSE_TIME_FIELD_DESC = new TField("responseTime", 10, 18);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public Map<String, TableInfo> tableMap;
    public long lastContact;
    public String name;
    public double osLoad;
    public long holdTime;
    public long lookups;
    public long indexCacheHits;
    public long indexCacheRequest;
    public long dataCacheHits;
    public long dataCacheRequest;
    public List<RecoveryStatus> logSorts;
    public long flushs;
    public long syncs;
    public List<BulkImportStatus> bulkImports;
    public long responseTime;
    private static final int __LASTCONTACT_ISSET_ID = 0;
    private static final int __OSLOAD_ISSET_ID = 1;
    private static final int __HOLDTIME_ISSET_ID = 2;
    private static final int __LOOKUPS_ISSET_ID = 3;
    private static final int __INDEXCACHEHITS_ISSET_ID = 4;
    private static final int __INDEXCACHEREQUEST_ISSET_ID = 5;
    private static final int __DATACACHEHITS_ISSET_ID = 6;
    private static final int __DATACACHEREQUEST_ISSET_ID = 7;
    private static final int __FLUSHS_ISSET_ID = 8;
    private static final int __SYNCS_ISSET_ID = 9;
    private static final int __RESPONSETIME_ISSET_ID = 10;
    private short __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TabletServerStatus() {
    }

    public TabletServerStatus(Map<String, TableInfo> tableMap, long lastContact, String name, double osLoad, long holdTime, long lookups, long indexCacheHits, long indexCacheRequest, long dataCacheHits, long dataCacheRequest, List<RecoveryStatus> logSorts, long flushs, long syncs, List<BulkImportStatus> bulkImports, long responseTime) {
        this();
        this.tableMap = tableMap;
        this.lastContact = lastContact;
        this.setLastContactIsSet(true);
        this.name = name;
        this.osLoad = osLoad;
        this.setOsLoadIsSet(true);
        this.holdTime = holdTime;
        this.setHoldTimeIsSet(true);
        this.lookups = lookups;
        this.setLookupsIsSet(true);
        this.indexCacheHits = indexCacheHits;
        this.setIndexCacheHitsIsSet(true);
        this.indexCacheRequest = indexCacheRequest;
        this.setIndexCacheRequestIsSet(true);
        this.dataCacheHits = dataCacheHits;
        this.setDataCacheHitsIsSet(true);
        this.dataCacheRequest = dataCacheRequest;
        this.setDataCacheRequestIsSet(true);
        this.logSorts = logSorts;
        this.flushs = flushs;
        this.setFlushsIsSet(true);
        this.syncs = syncs;
        this.setSyncsIsSet(true);
        this.bulkImports = bulkImports;
        this.responseTime = responseTime;
        this.setResponseTimeIsSet(true);
    }

    public TabletServerStatus(TabletServerStatus other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetTableMap()) {
            HashMap<String, TableInfo> __this__tableMap = new HashMap<String, TableInfo>(other.tableMap.size());
            for (Map.Entry<String, TableInfo> entry : other.tableMap.entrySet()) {
                String other_element_key = entry.getKey();
                TableInfo other_element_value = entry.getValue();
                String __this__tableMap_copy_key = other_element_key;
                TableInfo __this__tableMap_copy_value = new TableInfo(other_element_value);
                __this__tableMap.put(__this__tableMap_copy_key, __this__tableMap_copy_value);
            }
            this.tableMap = __this__tableMap;
        }
        this.lastContact = other.lastContact;
        if (other.isSetName()) {
            this.name = other.name;
        }
        this.osLoad = other.osLoad;
        this.holdTime = other.holdTime;
        this.lookups = other.lookups;
        this.indexCacheHits = other.indexCacheHits;
        this.indexCacheRequest = other.indexCacheRequest;
        this.dataCacheHits = other.dataCacheHits;
        this.dataCacheRequest = other.dataCacheRequest;
        if (other.isSetLogSorts()) {
            ArrayList<RecoveryStatus> __this__logSorts = new ArrayList<RecoveryStatus>(other.logSorts.size());
            for (RecoveryStatus recoveryStatus : other.logSorts) {
                __this__logSorts.add(new RecoveryStatus(recoveryStatus));
            }
            this.logSorts = __this__logSorts;
        }
        this.flushs = other.flushs;
        this.syncs = other.syncs;
        if (other.isSetBulkImports()) {
            ArrayList<BulkImportStatus> __this__bulkImports = new ArrayList<BulkImportStatus>(other.bulkImports.size());
            for (BulkImportStatus bulkImportStatus : other.bulkImports) {
                __this__bulkImports.add(new BulkImportStatus(bulkImportStatus));
            }
            this.bulkImports = __this__bulkImports;
        }
        this.responseTime = other.responseTime;
    }

    public TabletServerStatus deepCopy() {
        return new TabletServerStatus(this);
    }

    public void clear() {
        this.tableMap = null;
        this.setLastContactIsSet(false);
        this.lastContact = 0L;
        this.name = null;
        this.setOsLoadIsSet(false);
        this.osLoad = 0.0;
        this.setHoldTimeIsSet(false);
        this.holdTime = 0L;
        this.setLookupsIsSet(false);
        this.lookups = 0L;
        this.setIndexCacheHitsIsSet(false);
        this.indexCacheHits = 0L;
        this.setIndexCacheRequestIsSet(false);
        this.indexCacheRequest = 0L;
        this.setDataCacheHitsIsSet(false);
        this.dataCacheHits = 0L;
        this.setDataCacheRequestIsSet(false);
        this.dataCacheRequest = 0L;
        this.logSorts = null;
        this.setFlushsIsSet(false);
        this.flushs = 0L;
        this.setSyncsIsSet(false);
        this.syncs = 0L;
        this.bulkImports = null;
        this.setResponseTimeIsSet(false);
        this.responseTime = 0L;
    }

    public int getTableMapSize() {
        return this.tableMap == null ? 0 : this.tableMap.size();
    }

    public void putToTableMap(String key, TableInfo val) {
        if (this.tableMap == null) {
            this.tableMap = new HashMap<String, TableInfo>();
        }
        this.tableMap.put(key, val);
    }

    public Map<String, TableInfo> getTableMap() {
        return this.tableMap;
    }

    public TabletServerStatus setTableMap(Map<String, TableInfo> tableMap) {
        this.tableMap = tableMap;
        return this;
    }

    public void unsetTableMap() {
        this.tableMap = null;
    }

    public boolean isSetTableMap() {
        return this.tableMap != null;
    }

    public void setTableMapIsSet(boolean value) {
        if (!value) {
            this.tableMap = null;
        }
    }

    public long getLastContact() {
        return this.lastContact;
    }

    public TabletServerStatus setLastContact(long lastContact) {
        this.lastContact = lastContact;
        this.setLastContactIsSet(true);
        return this;
    }

    public void unsetLastContact() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)0);
    }

    public boolean isSetLastContact() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)0);
    }

    public void setLastContactIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public String getName() {
        return this.name;
    }

    public TabletServerStatus setName(String name) {
        this.name = name;
        return this;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    public double getOsLoad() {
        return this.osLoad;
    }

    public TabletServerStatus setOsLoad(double osLoad) {
        this.osLoad = osLoad;
        this.setOsLoadIsSet(true);
        return this;
    }

    public void unsetOsLoad() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)1);
    }

    public boolean isSetOsLoad() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)1);
    }

    public void setOsLoadIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getHoldTime() {
        return this.holdTime;
    }

    public TabletServerStatus setHoldTime(long holdTime) {
        this.holdTime = holdTime;
        this.setHoldTimeIsSet(true);
        return this;
    }

    public void unsetHoldTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)2);
    }

    public boolean isSetHoldTime() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)2);
    }

    public void setHoldTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public long getLookups() {
        return this.lookups;
    }

    public TabletServerStatus setLookups(long lookups) {
        this.lookups = lookups;
        this.setLookupsIsSet(true);
        return this;
    }

    public void unsetLookups() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)3);
    }

    public boolean isSetLookups() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)3);
    }

    public void setLookupsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public long getIndexCacheHits() {
        return this.indexCacheHits;
    }

    public TabletServerStatus setIndexCacheHits(long indexCacheHits) {
        this.indexCacheHits = indexCacheHits;
        this.setIndexCacheHitsIsSet(true);
        return this;
    }

    public void unsetIndexCacheHits() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)4);
    }

    public boolean isSetIndexCacheHits() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)4);
    }

    public void setIndexCacheHitsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public long getIndexCacheRequest() {
        return this.indexCacheRequest;
    }

    public TabletServerStatus setIndexCacheRequest(long indexCacheRequest) {
        this.indexCacheRequest = indexCacheRequest;
        this.setIndexCacheRequestIsSet(true);
        return this;
    }

    public void unsetIndexCacheRequest() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)5);
    }

    public boolean isSetIndexCacheRequest() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)5);
    }

    public void setIndexCacheRequestIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)5, (boolean)value);
    }

    public long getDataCacheHits() {
        return this.dataCacheHits;
    }

    public TabletServerStatus setDataCacheHits(long dataCacheHits) {
        this.dataCacheHits = dataCacheHits;
        this.setDataCacheHitsIsSet(true);
        return this;
    }

    public void unsetDataCacheHits() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)6);
    }

    public boolean isSetDataCacheHits() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)6);
    }

    public void setDataCacheHitsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)6, (boolean)value);
    }

    public long getDataCacheRequest() {
        return this.dataCacheRequest;
    }

    public TabletServerStatus setDataCacheRequest(long dataCacheRequest) {
        this.dataCacheRequest = dataCacheRequest;
        this.setDataCacheRequestIsSet(true);
        return this;
    }

    public void unsetDataCacheRequest() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)7);
    }

    public boolean isSetDataCacheRequest() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)7);
    }

    public void setDataCacheRequestIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)7, (boolean)value);
    }

    public int getLogSortsSize() {
        return this.logSorts == null ? 0 : this.logSorts.size();
    }

    public Iterator<RecoveryStatus> getLogSortsIterator() {
        return this.logSorts == null ? null : this.logSorts.iterator();
    }

    public void addToLogSorts(RecoveryStatus elem) {
        if (this.logSorts == null) {
            this.logSorts = new ArrayList<RecoveryStatus>();
        }
        this.logSorts.add(elem);
    }

    public List<RecoveryStatus> getLogSorts() {
        return this.logSorts;
    }

    public TabletServerStatus setLogSorts(List<RecoveryStatus> logSorts) {
        this.logSorts = logSorts;
        return this;
    }

    public void unsetLogSorts() {
        this.logSorts = null;
    }

    public boolean isSetLogSorts() {
        return this.logSorts != null;
    }

    public void setLogSortsIsSet(boolean value) {
        if (!value) {
            this.logSorts = null;
        }
    }

    public long getFlushs() {
        return this.flushs;
    }

    public TabletServerStatus setFlushs(long flushs) {
        this.flushs = flushs;
        this.setFlushsIsSet(true);
        return this;
    }

    public void unsetFlushs() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)8);
    }

    public boolean isSetFlushs() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)8);
    }

    public void setFlushsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)8, (boolean)value);
    }

    public long getSyncs() {
        return this.syncs;
    }

    public TabletServerStatus setSyncs(long syncs) {
        this.syncs = syncs;
        this.setSyncsIsSet(true);
        return this;
    }

    public void unsetSyncs() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)9);
    }

    public boolean isSetSyncs() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)9);
    }

    public void setSyncsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)9, (boolean)value);
    }

    public int getBulkImportsSize() {
        return this.bulkImports == null ? 0 : this.bulkImports.size();
    }

    public Iterator<BulkImportStatus> getBulkImportsIterator() {
        return this.bulkImports == null ? null : this.bulkImports.iterator();
    }

    public void addToBulkImports(BulkImportStatus elem) {
        if (this.bulkImports == null) {
            this.bulkImports = new ArrayList<BulkImportStatus>();
        }
        this.bulkImports.add(elem);
    }

    public List<BulkImportStatus> getBulkImports() {
        return this.bulkImports;
    }

    public TabletServerStatus setBulkImports(List<BulkImportStatus> bulkImports) {
        this.bulkImports = bulkImports;
        return this;
    }

    public void unsetBulkImports() {
        this.bulkImports = null;
    }

    public boolean isSetBulkImports() {
        return this.bulkImports != null;
    }

    public void setBulkImportsIsSet(boolean value) {
        if (!value) {
            this.bulkImports = null;
        }
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public TabletServerStatus setResponseTime(long responseTime) {
        this.responseTime = responseTime;
        this.setResponseTimeIsSet(true);
        return this;
    }

    public void unsetResponseTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)10);
    }

    public boolean isSetResponseTime() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)10);
    }

    public void setResponseTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)10, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TABLE_MAP: {
                if (value == null) {
                    this.unsetTableMap();
                    break;
                }
                this.setTableMap((Map)value);
                break;
            }
            case LAST_CONTACT: {
                if (value == null) {
                    this.unsetLastContact();
                    break;
                }
                this.setLastContact((Long)value);
                break;
            }
            case NAME: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((String)value);
                break;
            }
            case OS_LOAD: {
                if (value == null) {
                    this.unsetOsLoad();
                    break;
                }
                this.setOsLoad((Double)value);
                break;
            }
            case HOLD_TIME: {
                if (value == null) {
                    this.unsetHoldTime();
                    break;
                }
                this.setHoldTime((Long)value);
                break;
            }
            case LOOKUPS: {
                if (value == null) {
                    this.unsetLookups();
                    break;
                }
                this.setLookups((Long)value);
                break;
            }
            case INDEX_CACHE_HITS: {
                if (value == null) {
                    this.unsetIndexCacheHits();
                    break;
                }
                this.setIndexCacheHits((Long)value);
                break;
            }
            case INDEX_CACHE_REQUEST: {
                if (value == null) {
                    this.unsetIndexCacheRequest();
                    break;
                }
                this.setIndexCacheRequest((Long)value);
                break;
            }
            case DATA_CACHE_HITS: {
                if (value == null) {
                    this.unsetDataCacheHits();
                    break;
                }
                this.setDataCacheHits((Long)value);
                break;
            }
            case DATA_CACHE_REQUEST: {
                if (value == null) {
                    this.unsetDataCacheRequest();
                    break;
                }
                this.setDataCacheRequest((Long)value);
                break;
            }
            case LOG_SORTS: {
                if (value == null) {
                    this.unsetLogSorts();
                    break;
                }
                this.setLogSorts((List)value);
                break;
            }
            case FLUSHS: {
                if (value == null) {
                    this.unsetFlushs();
                    break;
                }
                this.setFlushs((Long)value);
                break;
            }
            case SYNCS: {
                if (value == null) {
                    this.unsetSyncs();
                    break;
                }
                this.setSyncs((Long)value);
                break;
            }
            case BULK_IMPORTS: {
                if (value == null) {
                    this.unsetBulkImports();
                    break;
                }
                this.setBulkImports((List)value);
                break;
            }
            case RESPONSE_TIME: {
                if (value == null) {
                    this.unsetResponseTime();
                    break;
                }
                this.setResponseTime((Long)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLE_MAP: {
                return this.getTableMap();
            }
            case LAST_CONTACT: {
                return this.getLastContact();
            }
            case NAME: {
                return this.getName();
            }
            case OS_LOAD: {
                return this.getOsLoad();
            }
            case HOLD_TIME: {
                return this.getHoldTime();
            }
            case LOOKUPS: {
                return this.getLookups();
            }
            case INDEX_CACHE_HITS: {
                return this.getIndexCacheHits();
            }
            case INDEX_CACHE_REQUEST: {
                return this.getIndexCacheRequest();
            }
            case DATA_CACHE_HITS: {
                return this.getDataCacheHits();
            }
            case DATA_CACHE_REQUEST: {
                return this.getDataCacheRequest();
            }
            case LOG_SORTS: {
                return this.getLogSorts();
            }
            case FLUSHS: {
                return this.getFlushs();
            }
            case SYNCS: {
                return this.getSyncs();
            }
            case BULK_IMPORTS: {
                return this.getBulkImports();
            }
            case RESPONSE_TIME: {
                return this.getResponseTime();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLE_MAP: {
                return this.isSetTableMap();
            }
            case LAST_CONTACT: {
                return this.isSetLastContact();
            }
            case NAME: {
                return this.isSetName();
            }
            case OS_LOAD: {
                return this.isSetOsLoad();
            }
            case HOLD_TIME: {
                return this.isSetHoldTime();
            }
            case LOOKUPS: {
                return this.isSetLookups();
            }
            case INDEX_CACHE_HITS: {
                return this.isSetIndexCacheHits();
            }
            case INDEX_CACHE_REQUEST: {
                return this.isSetIndexCacheRequest();
            }
            case DATA_CACHE_HITS: {
                return this.isSetDataCacheHits();
            }
            case DATA_CACHE_REQUEST: {
                return this.isSetDataCacheRequest();
            }
            case LOG_SORTS: {
                return this.isSetLogSorts();
            }
            case FLUSHS: {
                return this.isSetFlushs();
            }
            case SYNCS: {
                return this.isSetSyncs();
            }
            case BULK_IMPORTS: {
                return this.isSetBulkImports();
            }
            case RESPONSE_TIME: {
                return this.isSetResponseTime();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TabletServerStatus) {
            return this.equals((TabletServerStatus)that);
        }
        return false;
    }

    public boolean equals(TabletServerStatus that) {
        if (that == null) {
            return false;
        }
        boolean this_present_tableMap = this.isSetTableMap();
        boolean that_present_tableMap = that.isSetTableMap();
        if (this_present_tableMap || that_present_tableMap) {
            if (!this_present_tableMap || !that_present_tableMap) {
                return false;
            }
            if (!this.tableMap.equals(that.tableMap)) {
                return false;
            }
        }
        boolean this_present_lastContact = true;
        boolean that_present_lastContact = true;
        if (this_present_lastContact || that_present_lastContact) {
            if (!this_present_lastContact || !that_present_lastContact) {
                return false;
            }
            if (this.lastContact != that.lastContact) {
                return false;
            }
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_osLoad = true;
        boolean that_present_osLoad = true;
        if (this_present_osLoad || that_present_osLoad) {
            if (!this_present_osLoad || !that_present_osLoad) {
                return false;
            }
            if (this.osLoad != that.osLoad) {
                return false;
            }
        }
        boolean this_present_holdTime = true;
        boolean that_present_holdTime = true;
        if (this_present_holdTime || that_present_holdTime) {
            if (!this_present_holdTime || !that_present_holdTime) {
                return false;
            }
            if (this.holdTime != that.holdTime) {
                return false;
            }
        }
        boolean this_present_lookups = true;
        boolean that_present_lookups = true;
        if (this_present_lookups || that_present_lookups) {
            if (!this_present_lookups || !that_present_lookups) {
                return false;
            }
            if (this.lookups != that.lookups) {
                return false;
            }
        }
        boolean this_present_indexCacheHits = true;
        boolean that_present_indexCacheHits = true;
        if (this_present_indexCacheHits || that_present_indexCacheHits) {
            if (!this_present_indexCacheHits || !that_present_indexCacheHits) {
                return false;
            }
            if (this.indexCacheHits != that.indexCacheHits) {
                return false;
            }
        }
        boolean this_present_indexCacheRequest = true;
        boolean that_present_indexCacheRequest = true;
        if (this_present_indexCacheRequest || that_present_indexCacheRequest) {
            if (!this_present_indexCacheRequest || !that_present_indexCacheRequest) {
                return false;
            }
            if (this.indexCacheRequest != that.indexCacheRequest) {
                return false;
            }
        }
        boolean this_present_dataCacheHits = true;
        boolean that_present_dataCacheHits = true;
        if (this_present_dataCacheHits || that_present_dataCacheHits) {
            if (!this_present_dataCacheHits || !that_present_dataCacheHits) {
                return false;
            }
            if (this.dataCacheHits != that.dataCacheHits) {
                return false;
            }
        }
        boolean this_present_dataCacheRequest = true;
        boolean that_present_dataCacheRequest = true;
        if (this_present_dataCacheRequest || that_present_dataCacheRequest) {
            if (!this_present_dataCacheRequest || !that_present_dataCacheRequest) {
                return false;
            }
            if (this.dataCacheRequest != that.dataCacheRequest) {
                return false;
            }
        }
        boolean this_present_logSorts = this.isSetLogSorts();
        boolean that_present_logSorts = that.isSetLogSorts();
        if (this_present_logSorts || that_present_logSorts) {
            if (!this_present_logSorts || !that_present_logSorts) {
                return false;
            }
            if (!this.logSorts.equals(that.logSorts)) {
                return false;
            }
        }
        boolean this_present_flushs = true;
        boolean that_present_flushs = true;
        if (this_present_flushs || that_present_flushs) {
            if (!this_present_flushs || !that_present_flushs) {
                return false;
            }
            if (this.flushs != that.flushs) {
                return false;
            }
        }
        boolean this_present_syncs = true;
        boolean that_present_syncs = true;
        if (this_present_syncs || that_present_syncs) {
            if (!this_present_syncs || !that_present_syncs) {
                return false;
            }
            if (this.syncs != that.syncs) {
                return false;
            }
        }
        boolean this_present_bulkImports = this.isSetBulkImports();
        boolean that_present_bulkImports = that.isSetBulkImports();
        if (this_present_bulkImports || that_present_bulkImports) {
            if (!this_present_bulkImports || !that_present_bulkImports) {
                return false;
            }
            if (!this.bulkImports.equals(that.bulkImports)) {
                return false;
            }
        }
        boolean this_present_responseTime = true;
        boolean that_present_responseTime = true;
        if (this_present_responseTime || that_present_responseTime) {
            if (!this_present_responseTime || !that_present_responseTime) {
                return false;
            }
            if (this.responseTime != that.responseTime) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_tableMap = this.isSetTableMap();
        list.add(present_tableMap);
        if (present_tableMap) {
            list.add(this.tableMap);
        }
        boolean present_lastContact = true;
        list.add(present_lastContact);
        if (present_lastContact) {
            list.add(this.lastContact);
        }
        boolean present_name = this.isSetName();
        list.add(present_name);
        if (present_name) {
            list.add(this.name);
        }
        boolean present_osLoad = true;
        list.add(present_osLoad);
        if (present_osLoad) {
            list.add(this.osLoad);
        }
        boolean present_holdTime = true;
        list.add(present_holdTime);
        if (present_holdTime) {
            list.add(this.holdTime);
        }
        boolean present_lookups = true;
        list.add(present_lookups);
        if (present_lookups) {
            list.add(this.lookups);
        }
        boolean present_indexCacheHits = true;
        list.add(present_indexCacheHits);
        if (present_indexCacheHits) {
            list.add(this.indexCacheHits);
        }
        boolean present_indexCacheRequest = true;
        list.add(present_indexCacheRequest);
        if (present_indexCacheRequest) {
            list.add(this.indexCacheRequest);
        }
        boolean present_dataCacheHits = true;
        list.add(present_dataCacheHits);
        if (present_dataCacheHits) {
            list.add(this.dataCacheHits);
        }
        boolean present_dataCacheRequest = true;
        list.add(present_dataCacheRequest);
        if (present_dataCacheRequest) {
            list.add(this.dataCacheRequest);
        }
        boolean present_logSorts = this.isSetLogSorts();
        list.add(present_logSorts);
        if (present_logSorts) {
            list.add(this.logSorts);
        }
        boolean present_flushs = true;
        list.add(present_flushs);
        if (present_flushs) {
            list.add(this.flushs);
        }
        boolean present_syncs = true;
        list.add(present_syncs);
        if (present_syncs) {
            list.add(this.syncs);
        }
        boolean present_bulkImports = this.isSetBulkImports();
        list.add(present_bulkImports);
        if (present_bulkImports) {
            list.add(this.bulkImports);
        }
        boolean present_responseTime = true;
        list.add(present_responseTime);
        if (present_responseTime) {
            list.add(this.responseTime);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(TabletServerStatus other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetTableMap()).compareTo(other.isSetTableMap());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableMap() && (lastComparison = TBaseHelper.compareTo(this.tableMap, other.tableMap)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLastContact()).compareTo(other.isSetLastContact());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLastContact() && (lastComparison = TBaseHelper.compareTo((long)this.lastContact, (long)other.lastContact)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetName()).compareTo(other.isSetName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetName() && (lastComparison = TBaseHelper.compareTo((String)this.name, (String)other.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOsLoad()).compareTo(other.isSetOsLoad());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOsLoad() && (lastComparison = TBaseHelper.compareTo((double)this.osLoad, (double)other.osLoad)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHoldTime()).compareTo(other.isSetHoldTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHoldTime() && (lastComparison = TBaseHelper.compareTo((long)this.holdTime, (long)other.holdTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLookups()).compareTo(other.isSetLookups());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLookups() && (lastComparison = TBaseHelper.compareTo((long)this.lookups, (long)other.lookups)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIndexCacheHits()).compareTo(other.isSetIndexCacheHits());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIndexCacheHits() && (lastComparison = TBaseHelper.compareTo((long)this.indexCacheHits, (long)other.indexCacheHits)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIndexCacheRequest()).compareTo(other.isSetIndexCacheRequest());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIndexCacheRequest() && (lastComparison = TBaseHelper.compareTo((long)this.indexCacheRequest, (long)other.indexCacheRequest)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDataCacheHits()).compareTo(other.isSetDataCacheHits());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDataCacheHits() && (lastComparison = TBaseHelper.compareTo((long)this.dataCacheHits, (long)other.dataCacheHits)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDataCacheRequest()).compareTo(other.isSetDataCacheRequest());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDataCacheRequest() && (lastComparison = TBaseHelper.compareTo((long)this.dataCacheRequest, (long)other.dataCacheRequest)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLogSorts()).compareTo(other.isSetLogSorts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLogSorts() && (lastComparison = TBaseHelper.compareTo(this.logSorts, other.logSorts)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFlushs()).compareTo(other.isSetFlushs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFlushs() && (lastComparison = TBaseHelper.compareTo((long)this.flushs, (long)other.flushs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSyncs()).compareTo(other.isSetSyncs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSyncs() && (lastComparison = TBaseHelper.compareTo((long)this.syncs, (long)other.syncs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBulkImports()).compareTo(other.isSetBulkImports());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBulkImports() && (lastComparison = TBaseHelper.compareTo(this.bulkImports, other.bulkImports)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetResponseTime()).compareTo(other.isSetResponseTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetResponseTime() && (lastComparison = TBaseHelper.compareTo((long)this.responseTime, (long)other.responseTime)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TabletServerStatus(");
        boolean first = true;
        sb.append("tableMap:");
        if (this.tableMap == null) {
            sb.append("null");
        } else {
            sb.append(this.tableMap);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("lastContact:");
        sb.append(this.lastContact);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            sb.append(this.name);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("osLoad:");
        sb.append(this.osLoad);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("holdTime:");
        sb.append(this.holdTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("lookups:");
        sb.append(this.lookups);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("indexCacheHits:");
        sb.append(this.indexCacheHits);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("indexCacheRequest:");
        sb.append(this.indexCacheRequest);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dataCacheHits:");
        sb.append(this.dataCacheHits);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dataCacheRequest:");
        sb.append(this.dataCacheRequest);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("logSorts:");
        if (this.logSorts == null) {
            sb.append("null");
        } else {
            sb.append(this.logSorts);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("flushs:");
        sb.append(this.flushs);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("syncs:");
        sb.append(this.syncs);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("bulkImports:");
        if (this.bulkImports == null) {
            sb.append("null");
        } else {
            sb.append(this.bulkImports);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("responseTime:");
        sb.append(this.responseTime);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TabletServerStatusStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TabletServerStatusTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLE_MAP, new FieldMetaData("tableMap", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), (FieldValueMetaData)new StructMetaData(12, TableInfo.class))));
        tmpMap.put(_Fields.LAST_CONTACT, new FieldMetaData("lastContact", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.NAME, new FieldMetaData("name", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.OS_LOAD, new FieldMetaData("osLoad", 3, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.HOLD_TIME, new FieldMetaData("holdTime", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.LOOKUPS, new FieldMetaData("lookups", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.INDEX_CACHE_HITS, new FieldMetaData("indexCacheHits", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.INDEX_CACHE_REQUEST, new FieldMetaData("indexCacheRequest", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DATA_CACHE_HITS, new FieldMetaData("dataCacheHits", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DATA_CACHE_REQUEST, new FieldMetaData("dataCacheRequest", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.LOG_SORTS, new FieldMetaData("logSorts", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, RecoveryStatus.class))));
        tmpMap.put(_Fields.FLUSHS, new FieldMetaData("flushs", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.SYNCS, new FieldMetaData("syncs", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.BULK_IMPORTS, new FieldMetaData("bulkImports", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, BulkImportStatus.class))));
        tmpMap.put(_Fields.RESPONSE_TIME, new FieldMetaData("responseTime", 3, new FieldValueMetaData(10)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TabletServerStatus.class, metaDataMap);
    }

    private static class TabletServerStatusTupleScheme
    extends TupleScheme<TabletServerStatus> {
        private TabletServerStatusTupleScheme() {
        }

        public void write(TProtocol prot, TabletServerStatus struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetTableMap()) {
                optionals.set(0);
            }
            if (struct.isSetLastContact()) {
                optionals.set(1);
            }
            if (struct.isSetName()) {
                optionals.set(2);
            }
            if (struct.isSetOsLoad()) {
                optionals.set(3);
            }
            if (struct.isSetHoldTime()) {
                optionals.set(4);
            }
            if (struct.isSetLookups()) {
                optionals.set(5);
            }
            if (struct.isSetIndexCacheHits()) {
                optionals.set(6);
            }
            if (struct.isSetIndexCacheRequest()) {
                optionals.set(7);
            }
            if (struct.isSetDataCacheHits()) {
                optionals.set(8);
            }
            if (struct.isSetDataCacheRequest()) {
                optionals.set(9);
            }
            if (struct.isSetLogSorts()) {
                optionals.set(10);
            }
            if (struct.isSetFlushs()) {
                optionals.set(11);
            }
            if (struct.isSetSyncs()) {
                optionals.set(12);
            }
            if (struct.isSetBulkImports()) {
                optionals.set(13);
            }
            if (struct.isSetResponseTime()) {
                optionals.set(14);
            }
            oprot.writeBitSet(optionals, 15);
            if (struct.isSetTableMap()) {
                oprot.writeI32(struct.tableMap.size());
                for (Map.Entry<String, TableInfo> _iter13 : struct.tableMap.entrySet()) {
                    oprot.writeString(_iter13.getKey());
                    _iter13.getValue().write((TProtocol)oprot);
                }
            }
            if (struct.isSetLastContact()) {
                oprot.writeI64(struct.lastContact);
            }
            if (struct.isSetName()) {
                oprot.writeString(struct.name);
            }
            if (struct.isSetOsLoad()) {
                oprot.writeDouble(struct.osLoad);
            }
            if (struct.isSetHoldTime()) {
                oprot.writeI64(struct.holdTime);
            }
            if (struct.isSetLookups()) {
                oprot.writeI64(struct.lookups);
            }
            if (struct.isSetIndexCacheHits()) {
                oprot.writeI64(struct.indexCacheHits);
            }
            if (struct.isSetIndexCacheRequest()) {
                oprot.writeI64(struct.indexCacheRequest);
            }
            if (struct.isSetDataCacheHits()) {
                oprot.writeI64(struct.dataCacheHits);
            }
            if (struct.isSetDataCacheRequest()) {
                oprot.writeI64(struct.dataCacheRequest);
            }
            if (struct.isSetLogSorts()) {
                oprot.writeI32(struct.logSorts.size());
                for (RecoveryStatus _iter14 : struct.logSorts) {
                    _iter14.write((TProtocol)oprot);
                }
            }
            if (struct.isSetFlushs()) {
                oprot.writeI64(struct.flushs);
            }
            if (struct.isSetSyncs()) {
                oprot.writeI64(struct.syncs);
            }
            if (struct.isSetBulkImports()) {
                oprot.writeI32(struct.bulkImports.size());
                for (BulkImportStatus _iter15 : struct.bulkImports) {
                    _iter15.write((TProtocol)oprot);
                }
            }
            if (struct.isSetResponseTime()) {
                oprot.writeI64(struct.responseTime);
            }
        }

        public void read(TProtocol prot, TabletServerStatus struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(15);
            if (incoming.get(0)) {
                TMap _map16 = new TMap(11, 12, iprot.readI32());
                struct.tableMap = new HashMap<String, TableInfo>(2 * _map16.size);
                for (int _i19 = 0; _i19 < _map16.size; ++_i19) {
                    String _key17 = iprot.readString();
                    TableInfo _val18 = new TableInfo();
                    _val18.read((TProtocol)iprot);
                    struct.tableMap.put(_key17, _val18);
                }
                struct.setTableMapIsSet(true);
            }
            if (incoming.get(1)) {
                struct.lastContact = iprot.readI64();
                struct.setLastContactIsSet(true);
            }
            if (incoming.get(2)) {
                struct.name = iprot.readString();
                struct.setNameIsSet(true);
            }
            if (incoming.get(3)) {
                struct.osLoad = iprot.readDouble();
                struct.setOsLoadIsSet(true);
            }
            if (incoming.get(4)) {
                struct.holdTime = iprot.readI64();
                struct.setHoldTimeIsSet(true);
            }
            if (incoming.get(5)) {
                struct.lookups = iprot.readI64();
                struct.setLookupsIsSet(true);
            }
            if (incoming.get(6)) {
                struct.indexCacheHits = iprot.readI64();
                struct.setIndexCacheHitsIsSet(true);
            }
            if (incoming.get(7)) {
                struct.indexCacheRequest = iprot.readI64();
                struct.setIndexCacheRequestIsSet(true);
            }
            if (incoming.get(8)) {
                struct.dataCacheHits = iprot.readI64();
                struct.setDataCacheHitsIsSet(true);
            }
            if (incoming.get(9)) {
                struct.dataCacheRequest = iprot.readI64();
                struct.setDataCacheRequestIsSet(true);
            }
            if (incoming.get(10)) {
                TList _list20 = new TList(12, iprot.readI32());
                struct.logSorts = new ArrayList<RecoveryStatus>(_list20.size);
                for (int _i22 = 0; _i22 < _list20.size; ++_i22) {
                    RecoveryStatus _elem21 = new RecoveryStatus();
                    _elem21.read((TProtocol)iprot);
                    struct.logSorts.add(_elem21);
                }
                struct.setLogSortsIsSet(true);
            }
            if (incoming.get(11)) {
                struct.flushs = iprot.readI64();
                struct.setFlushsIsSet(true);
            }
            if (incoming.get(12)) {
                struct.syncs = iprot.readI64();
                struct.setSyncsIsSet(true);
            }
            if (incoming.get(13)) {
                TList _list23 = new TList(12, iprot.readI32());
                struct.bulkImports = new ArrayList<BulkImportStatus>(_list23.size);
                for (int _i25 = 0; _i25 < _list23.size; ++_i25) {
                    BulkImportStatus _elem24 = new BulkImportStatus();
                    _elem24.read((TProtocol)iprot);
                    struct.bulkImports.add(_elem24);
                }
                struct.setBulkImportsIsSet(true);
            }
            if (incoming.get(14)) {
                struct.responseTime = iprot.readI64();
                struct.setResponseTimeIsSet(true);
            }
        }
    }

    private static class TabletServerStatusTupleSchemeFactory
    implements SchemeFactory {
        private TabletServerStatusTupleSchemeFactory() {
        }

        public TabletServerStatusTupleScheme getScheme() {
            return new TabletServerStatusTupleScheme();
        }
    }

    private static class TabletServerStatusStandardScheme
    extends StandardScheme<TabletServerStatus> {
        private TabletServerStatusStandardScheme() {
        }

        public void read(TProtocol iprot, TabletServerStatus struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 13) {
                            TMap _map0 = iprot.readMapBegin();
                            struct.tableMap = new HashMap<String, TableInfo>(2 * _map0.size);
                            for (int _i3 = 0; _i3 < _map0.size; ++_i3) {
                                String _key1 = iprot.readString();
                                TableInfo _val2 = new TableInfo();
                                _val2.read(iprot);
                                struct.tableMap.put(_key1, _val2);
                            }
                            iprot.readMapEnd();
                            struct.setTableMapIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.lastContact = iprot.readI64();
                            struct.setLastContactIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.name = iprot.readString();
                            struct.setNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 4) {
                            struct.osLoad = iprot.readDouble();
                            struct.setOsLoadIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 10) {
                            struct.holdTime = iprot.readI64();
                            struct.setHoldTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.lookups = iprot.readI64();
                            struct.setLookupsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 10) {
                            struct.indexCacheHits = iprot.readI64();
                            struct.setIndexCacheHitsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 10) {
                            struct.indexCacheRequest = iprot.readI64();
                            struct.setIndexCacheRequestIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 10) {
                            struct.dataCacheHits = iprot.readI64();
                            struct.setDataCacheHitsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 10) {
                            struct.dataCacheRequest = iprot.readI64();
                            struct.setDataCacheRequestIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 15) {
                            TList _list4 = iprot.readListBegin();
                            struct.logSorts = new ArrayList<RecoveryStatus>(_list4.size);
                            for (int _i6 = 0; _i6 < _list4.size; ++_i6) {
                                RecoveryStatus _elem5 = new RecoveryStatus();
                                _elem5.read(iprot);
                                struct.logSorts.add(_elem5);
                            }
                            iprot.readListEnd();
                            struct.setLogSortsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 15: {
                        if (schemeField.type == 10) {
                            struct.flushs = iprot.readI64();
                            struct.setFlushsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 16: {
                        if (schemeField.type == 10) {
                            struct.syncs = iprot.readI64();
                            struct.setSyncsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 17: {
                        if (schemeField.type == 15) {
                            TList _list7 = iprot.readListBegin();
                            struct.bulkImports = new ArrayList<BulkImportStatus>(_list7.size);
                            for (int _i9 = 0; _i9 < _list7.size; ++_i9) {
                                BulkImportStatus _elem8 = new BulkImportStatus();
                                _elem8.read(iprot);
                                struct.bulkImports.add(_elem8);
                            }
                            iprot.readListEnd();
                            struct.setBulkImportsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 18: {
                        if (schemeField.type == 10) {
                            struct.responseTime = iprot.readI64();
                            struct.setResponseTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TabletServerStatus struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.tableMap != null) {
                oprot.writeFieldBegin(TABLE_MAP_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 12, struct.tableMap.size()));
                for (Map.Entry<String, TableInfo> _iter10 : struct.tableMap.entrySet()) {
                    oprot.writeString(_iter10.getKey());
                    _iter10.getValue().write(oprot);
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(LAST_CONTACT_FIELD_DESC);
            oprot.writeI64(struct.lastContact);
            oprot.writeFieldEnd();
            if (struct.name != null) {
                oprot.writeFieldBegin(NAME_FIELD_DESC);
                oprot.writeString(struct.name);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(OS_LOAD_FIELD_DESC);
            oprot.writeDouble(struct.osLoad);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(HOLD_TIME_FIELD_DESC);
            oprot.writeI64(struct.holdTime);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(LOOKUPS_FIELD_DESC);
            oprot.writeI64(struct.lookups);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(INDEX_CACHE_HITS_FIELD_DESC);
            oprot.writeI64(struct.indexCacheHits);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(INDEX_CACHE_REQUEST_FIELD_DESC);
            oprot.writeI64(struct.indexCacheRequest);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(DATA_CACHE_HITS_FIELD_DESC);
            oprot.writeI64(struct.dataCacheHits);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(DATA_CACHE_REQUEST_FIELD_DESC);
            oprot.writeI64(struct.dataCacheRequest);
            oprot.writeFieldEnd();
            if (struct.logSorts != null) {
                oprot.writeFieldBegin(LOG_SORTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.logSorts.size()));
                for (RecoveryStatus _iter11 : struct.logSorts) {
                    _iter11.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(FLUSHS_FIELD_DESC);
            oprot.writeI64(struct.flushs);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(SYNCS_FIELD_DESC);
            oprot.writeI64(struct.syncs);
            oprot.writeFieldEnd();
            if (struct.bulkImports != null) {
                oprot.writeFieldBegin(BULK_IMPORTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.bulkImports.size()));
                for (BulkImportStatus _iter12 : struct.bulkImports) {
                    _iter12.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(RESPONSE_TIME_FIELD_DESC);
            oprot.writeI64(struct.responseTime);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TabletServerStatusStandardSchemeFactory
    implements SchemeFactory {
        private TabletServerStatusStandardSchemeFactory() {
        }

        public TabletServerStatusStandardScheme getScheme() {
            return new TabletServerStatusStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLE_MAP(1, "tableMap"),
        LAST_CONTACT(2, "lastContact"),
        NAME(3, "name"),
        OS_LOAD(5, "osLoad"),
        HOLD_TIME(7, "holdTime"),
        LOOKUPS(8, "lookups"),
        INDEX_CACHE_HITS(10, "indexCacheHits"),
        INDEX_CACHE_REQUEST(11, "indexCacheRequest"),
        DATA_CACHE_HITS(12, "dataCacheHits"),
        DATA_CACHE_REQUEST(13, "dataCacheRequest"),
        LOG_SORTS(14, "logSorts"),
        FLUSHS(15, "flushs"),
        SYNCS(16, "syncs"),
        BULK_IMPORTS(17, "bulkImports"),
        RESPONSE_TIME(18, "responseTime");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLE_MAP;
                }
                case 2: {
                    return LAST_CONTACT;
                }
                case 3: {
                    return NAME;
                }
                case 5: {
                    return OS_LOAD;
                }
                case 7: {
                    return HOLD_TIME;
                }
                case 8: {
                    return LOOKUPS;
                }
                case 10: {
                    return INDEX_CACHE_HITS;
                }
                case 11: {
                    return INDEX_CACHE_REQUEST;
                }
                case 12: {
                    return DATA_CACHE_HITS;
                }
                case 13: {
                    return DATA_CACHE_REQUEST;
                }
                case 14: {
                    return LOG_SORTS;
                }
                case 15: {
                    return FLUSHS;
                }
                case 16: {
                    return SYNCS;
                }
                case 17: {
                    return BULK_IMPORTS;
                }
                case 18: {
                    return RESPONSE_TIME;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

