/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;

public class DruidTimeseriesQueryRecordReader
extends DruidQueryRecordReader<Result<TimeseriesResultValue>> {
    private static final TypeReference TYPE_REFERENCE = new TypeReference<Result<TimeseriesResultValue>>(){};
    private Result<TimeseriesResultValue> current;

    @Override
    protected JavaType getResultTypeDef() {
        return DruidStorageHandlerUtils.JSON_MAPPER.getTypeFactory().constructType(TYPE_REFERENCE);
    }

    @Override
    public boolean nextKeyValue() {
        if (this.getQueryResultsIterator().hasNext()) {
            this.current = (Result)this.getQueryResultsIterator().next();
            return true;
        }
        return false;
    }

    @Override
    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    @Override
    public DruidWritable getCurrentValue() throws IOException, InterruptedException {
        DruidWritable value = new DruidWritable(false);
        value.getValue().put("timestamp", this.current.getTimestamp() == null ? null : Long.valueOf(this.current.getTimestamp().getMillis()));
        value.getValue().putAll(this.current.getValue().getBaseObject());
        return value;
    }

    @Override
    public boolean next(NullWritable key, DruidWritable value) {
        if (this.nextKeyValue()) {
            value.getValue().clear();
            value.getValue().put("timestamp", this.current.getTimestamp() == null ? null : Long.valueOf(this.current.getTimestamp().getMillis()));
            value.getValue().putAll(this.current.getValue().getBaseObject());
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() throws IOException {
        return this.getQueryResultsIterator().hasNext() ? 0.0f : 1.0f;
    }
}

