/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.BoundType;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableRangeSet;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.TreeRangeSet;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidTable;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.Granularities;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.Granularity;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.TimeExtractionFunction;
import org.apache.hive.druid.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.util.DateString;
import org.apache.hive.druid.org.apache.calcite.util.RangeSets;
import org.apache.hive.druid.org.apache.calcite.util.Sarg;
import org.apache.hive.druid.org.apache.calcite.util.TimestampString;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.apache.hive.druid.org.apache.calcite.util.trace.CalciteTrace;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;

public class DruidDateTimeUtils {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();

    private DruidDateTimeUtils() {
    }

    public static @Nullable List<Interval> createInterval(RexNode e) {
        List<Range<Long>> ranges = DruidDateTimeUtils.extractRanges(e, false);
        if (ranges == null) {
            return null;
        }
        TreeRangeSet<Long> condensedRanges = TreeRangeSet.create();
        for (Range<Long> r : ranges) {
            condensedRanges.add(r);
        }
        LOGGER.debug("Inferred ranges on interval : {}", condensedRanges);
        return DruidDateTimeUtils.toInterval(ImmutableList.copyOf(condensedRanges.asRanges()));
    }

    protected static List<Interval> toInterval(List<Range<Long>> ranges) {
        List<Interval> intervals = Util.transform(ranges, range -> {
            long end;
            if (!range.hasLowerBound() && !range.hasUpperBound()) {
                return DruidTable.DEFAULT_INTERVAL;
            }
            long start = range.hasLowerBound() ? ((Long)range.lowerEndpoint()).longValue() : DruidTable.DEFAULT_INTERVAL.getStartMillis();
            long l = end = range.hasUpperBound() ? ((Long)range.upperEndpoint()).longValue() : DruidTable.DEFAULT_INTERVAL.getEndMillis();
            if (range.hasLowerBound() && range.lowerBoundType() == BoundType.OPEN) {
                ++start;
            }
            if (range.hasUpperBound() && range.upperBoundType() == BoundType.CLOSED) {
                ++end;
            }
            return new Interval(start, end, (Chronology)ISOChronology.getInstanceUTC());
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Converted time ranges " + ranges + " to interval " + intervals);
        }
        return intervals;
    }

    protected static @Nullable List<Range<Long>> extractRanges(RexNode node, boolean withNot) {
        switch (node.getKind()) {
            case EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case DRUID_IN: 
            case SEARCH: {
                return DruidDateTimeUtils.leafToRanges((RexCall)node, withNot);
            }
            case NOT: {
                return DruidDateTimeUtils.extractRanges(((RexCall)node).getOperands().get(0), !withNot);
            }
            case OR: {
                RexCall call = (RexCall)node;
                ArrayList<Range<Long>> intervals = new ArrayList<Range<Long>>();
                for (RexNode child : call.getOperands()) {
                    List<Range<Long>> extracted = DruidDateTimeUtils.extractRanges(child, withNot);
                    if (extracted == null) continue;
                    intervals.addAll(extracted);
                }
                return intervals;
            }
            case AND: {
                RexCall call = (RexCall)node;
                ArrayList<Range<Long>> ranges = new ArrayList<Range<Long>>();
                for (RexNode child : call.getOperands()) {
                    List<Range<Long>> extractedRanges = DruidDateTimeUtils.extractRanges(child, false);
                    if (extractedRanges == null || extractedRanges.isEmpty()) {
                        return null;
                    }
                    if (ranges.isEmpty()) {
                        ranges.addAll(extractedRanges);
                        continue;
                    }
                    ArrayList<Range<Long>> overlapped = new ArrayList<Range<Long>>();
                    for (Range range : ranges) {
                        for (Range<Long> interval : extractedRanges) {
                            if (!range.isConnected(interval)) continue;
                            overlapped.add(range.intersection(interval));
                        }
                    }
                    ranges = overlapped;
                }
                return ranges;
            }
        }
        return null;
    }

    protected static @Nullable List<Range<Long>> leafToRanges(RexCall call, boolean withNot) {
        switch (call.getKind()) {
            case EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                Long value;
                SqlKind kind = call.getKind();
                if (call.getOperands().get(0) instanceof RexInputRef && DruidDateTimeUtils.literalValue(call.getOperands().get(1)) != null) {
                    value = DruidDateTimeUtils.literalValue(call.getOperands().get(1));
                } else if (call.getOperands().get(1) instanceof RexInputRef && DruidDateTimeUtils.literalValue(call.getOperands().get(0)) != null) {
                    value = DruidDateTimeUtils.literalValue(call.getOperands().get(0));
                    kind = kind.reverse();
                } else {
                    return null;
                }
                switch (kind) {
                    case LESS_THAN: {
                        return ImmutableList.of(withNot ? Range.atLeast(value) : Range.lessThan(value));
                    }
                    case LESS_THAN_OR_EQUAL: {
                        return ImmutableList.of(withNot ? Range.greaterThan(value) : Range.atMost(value));
                    }
                    case GREATER_THAN: {
                        return ImmutableList.of(withNot ? Range.atMost(value) : Range.greaterThan(value));
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        return ImmutableList.of(withNot ? Range.lessThan(value) : Range.atLeast(value));
                    }
                }
                if (!withNot) {
                    return ImmutableList.of(Range.closed(value, value));
                }
                return ImmutableList.of(Range.lessThan(value), Range.greaterThan(value));
            }
            case BETWEEN: {
                boolean inverted;
                if (DruidDateTimeUtils.literalValue(call.getOperands().get(2)) == null || DruidDateTimeUtils.literalValue(call.getOperands().get(3)) == null) {
                    return null;
                }
                Long value1 = DruidDateTimeUtils.literalValue(call.getOperands().get(2));
                Long value2 = DruidDateTimeUtils.literalValue(call.getOperands().get(3));
                boolean bl = inverted = value1.compareTo(value2) > 0;
                if (!withNot) {
                    return ImmutableList.of(inverted ? Range.closed(value2, value1) : Range.closed(value1, value2));
                }
                return ImmutableList.of(Range.lessThan(inverted ? value2 : value1), Range.greaterThan(inverted ? value1 : value2));
            }
            case DRUID_IN: {
                ImmutableList.Builder ranges = ImmutableList.builder();
                for (RexNode operand : Util.skip(call.operands)) {
                    Long element = DruidDateTimeUtils.literalValue(operand);
                    if (element == null) {
                        return null;
                    }
                    if (withNot) {
                        ranges.add(Range.lessThan(element));
                        ranges.add(Range.greaterThan(element));
                        continue;
                    }
                    ranges.add(Range.closed(element, element));
                }
                return ranges.build();
            }
            case SEARCH: {
                RexLiteral right = (RexLiteral)call.operands.get(1);
                Sarg sarg = right.getValueAs(Sarg.class);
                ImmutableList.Builder ranges = ImmutableList.builder();
                for (Range range : sarg.rangeSet.asRanges()) {
                    Range<Long> range2 = RangeSets.copy(range, DruidDateTimeUtils::toLong);
                    if (withNot) {
                        ranges.addAll((Iterable)((ImmutableRangeSet)ImmutableRangeSet.of(range2).complement()).asRanges());
                        continue;
                    }
                    ranges.add(range2);
                }
                return ranges.build();
            }
        }
        return null;
    }

    private static Long toLong(Comparable comparable) {
        if (comparable instanceof TimestampString) {
            TimestampString timestampString = (TimestampString)comparable;
            return timestampString.getMillisSinceEpoch();
        }
        if (comparable instanceof DateString) {
            DateString dataString = (DateString)comparable;
            return dataString.getMillisSinceEpoch();
        }
        throw new AssertionError((Object)("unsupported type: " + comparable.getClass()));
    }

    protected static @Nullable Long literalValue(RexNode node) {
        switch (node.getKind()) {
            case LITERAL: {
                switch (((RexLiteral)node).getTypeName()) {
                    case TIMESTAMP: 
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        TimestampString tsVal = ((RexLiteral)node).getValueAs(TimestampString.class);
                        if (tsVal == null) {
                            return null;
                        }
                        return tsVal.getMillisSinceEpoch();
                    }
                    case DATE: {
                        DateString dateVal = ((RexLiteral)node).getValueAs(DateString.class);
                        if (dateVal == null) {
                            return null;
                        }
                        return dateVal.getMillisSinceEpoch();
                    }
                }
                break;
            }
            case CAST: {
                assert (node instanceof RexCall);
                RexCall call = (RexCall)node;
                RexNode operand = call.getOperands().get(0);
                RelDataType callType = call.getType();
                RelDataType operandType = operand.getType();
                if (operand.getKind() != SqlKind.LITERAL || callType.getSqlTypeName() != operandType.getSqlTypeName() || callType.getSqlTypeName() != SqlTypeName.DATE && callType.getSqlTypeName() != SqlTypeName.TIMESTAMP && callType.getSqlTypeName() != SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE || !callType.isNullable() || operandType.isNullable()) break;
                return DruidDateTimeUtils.literalValue(operand);
            }
        }
        return null;
    }

    public static @Nullable Granularity extractGranularity(RexNode node, String timeZone) {
        int valueIndex;
        int flagIndex;
        if (TimeExtractionFunction.isValidTimeExtract(node)) {
            flagIndex = 0;
            valueIndex = 1;
        } else if (TimeExtractionFunction.isValidTimeFloor(node)) {
            valueIndex = 0;
            flagIndex = 1;
        } else {
            return null;
        }
        RexCall call = (RexCall)node;
        RexNode value = (RexNode)call.operands.get(valueIndex);
        RexLiteral flag = (RexLiteral)call.operands.get(flagIndex);
        TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
        RelDataType valueType = value.getType();
        if (valueType.getSqlTypeName() == SqlTypeName.DATE || valueType.getSqlTypeName() == SqlTypeName.TIMESTAMP) {
            return Granularities.createGranularity(timeUnit, "UTC");
        }
        if (valueType.getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return Granularities.createGranularity(timeUnit, timeZone);
        }
        return null;
    }

    public static @Nullable String toISOPeriodFormat(Granularity.Type type) {
        switch (type) {
            case SECOND: {
                return Period.seconds((int)1).toString();
            }
            case MINUTE: {
                return Period.minutes((int)1).toString();
            }
            case HOUR: {
                return Period.hours((int)1).toString();
            }
            case DAY: {
                return Period.days((int)1).toString();
            }
            case WEEK: {
                return Period.weeks((int)1).toString();
            }
            case MONTH: {
                return Period.months((int)1).toString();
            }
            case QUARTER: {
                return Period.months((int)3).toString();
            }
            case YEAR: {
                return Period.years((int)1).toString();
            }
        }
        return null;
    }

    public static @Nullable Granularity.Type toDruidGranularity(TimeUnitRange timeUnit) {
        if (timeUnit == null) {
            return null;
        }
        switch (timeUnit) {
            case YEAR: {
                return Granularity.Type.YEAR;
            }
            case QUARTER: {
                return Granularity.Type.QUARTER;
            }
            case MONTH: {
                return Granularity.Type.MONTH;
            }
            case WEEK: {
                return Granularity.Type.WEEK;
            }
            case DAY: {
                return Granularity.Type.DAY;
            }
            case HOUR: {
                return Granularity.Type.HOUR;
            }
            case MINUTE: {
                return Granularity.Type.MINUTE;
            }
            case SECOND: {
                return Granularity.Type.SECOND;
            }
        }
        return null;
    }
}

