/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.interpreter;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.DataContext;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.hive.druid.org.apache.calcite.config.CalciteSystemProperty;
import org.apache.hive.druid.org.apache.calcite.interpreter.Context;
import org.apache.hive.druid.org.apache.calcite.interpreter.Interpreter;
import org.apache.hive.druid.org.apache.calcite.interpreter.Scalar;
import org.apache.hive.druid.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.linq4j.function.Function1;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Statement;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexProgram;
import org.apache.hive.druid.org.apache.calcite.rex.RexProgramBuilder;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.hive.druid.org.apache.calcite.util.BuiltInMethod;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.ICompilerFactory;

public class JaninoRexCompiler
implements Interpreter.ScalarCompiler {
    private final RexBuilder rexBuilder;

    public JaninoRexCompiler(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
    }

    @Override
    public Scalar.Producer compile(List<RexNode> nodes, RelDataType inputRowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, this.rexBuilder);
        for (RexNode node : nodes) {
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder list = new BlockBuilder();
        BlockBuilder staticList = new BlockBuilder().withRemoveUnused(false);
        ParameterExpression context_ = Expressions.parameter(Context.class, "context");
        ParameterExpression outputValues_ = Expressions.parameter(Object[].class, "outputValues");
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl(this.rexBuilder.getTypeFactory().getTypeSystem());
        RexToLixTranslator.InputGetterImpl inputGetter = new RexToLixTranslator.InputGetterImpl(Expressions.field((Expression)context_, BuiltInMethod.CONTEXT_VALUES.field), PhysTypeImpl.of(javaTypeFactory, inputRowType, JavaRowFormat.ARRAY, false));
        Function1<String, RexToLixTranslator.InputGetter> correlates = a0 -> {
            throw new UnsupportedOperationException();
        };
        MemberExpression root = Expressions.field((Expression)context_, BuiltInMethod.CONTEXT_ROOT.field);
        SqlConformanceEnum conformance = SqlConformanceEnum.DEFAULT;
        List<Expression> expressionList = RexToLixTranslator.translateProjects(program, javaTypeFactory, conformance, list, staticList, null, root, inputGetter, correlates);
        Ord.forEach(expressionList, (expression, i) -> list.add(Expressions.statement(Expressions.assign(Expressions.arrayIndex(outputValues_, Expressions.constant(i)), expression))));
        return JaninoRexCompiler.baz(context_, outputValues_, list.toBlock(), staticList.toBlock().statements);
    }

    static Scalar.Producer baz(ParameterExpression context_, ParameterExpression outputValues_, BlockStatement block, List<Statement> declList) {
        ArrayList<MemberDeclaration> declarations = new ArrayList<MemberDeclaration>();
        ArrayList<MethodDeclaration> innerDeclarations = new ArrayList<MethodDeclaration>();
        ArrayList<Statement> statements = new ArrayList<Statement>(declList);
        statements.add(Expressions.return_(null, Expressions.new_(Scalar.class, ImmutableList.of(), innerDeclarations)));
        declarations.add(Expressions.methodDecl(1, Scalar.class, BuiltInMethod.FUNCTION_APPLY.method.getName(), ImmutableList.of(DataContext.ROOT), Expressions.block(statements)));
        ParameterExpression objectRoot = Expressions.parameter(Object.class, "root");
        declarations.add(Expressions.methodDecl(1, Object.class, BuiltInMethod.FUNCTION_APPLY.method.getName(), ImmutableList.of(objectRoot), Expressions.block(Expressions.return_(null, Expressions.call((Expression)Expressions.parameter(Scalar.Producer.class, "this"), BuiltInMethod.FUNCTION_APPLY.method, Expressions.convert_(objectRoot, DataContext.class))))));
        innerDeclarations.add(Expressions.methodDecl(1, Void.TYPE, BuiltInMethod.SCALAR_EXECUTE2.method.getName(), ImmutableList.of(context_, outputValues_), block));
        BlockBuilder builder = new BlockBuilder();
        Expression values_ = builder.append("values", Expressions.newArrayBounds(Object.class, 1, Expressions.constant(1)));
        builder.add(Expressions.statement(Expressions.call((Expression)Expressions.parameter(Scalar.class, "this"), BuiltInMethod.SCALAR_EXECUTE2.method, context_, values_)));
        builder.add(Expressions.return_(null, Expressions.arrayIndex(values_, Expressions.constant(0))));
        innerDeclarations.add(Expressions.methodDecl(1, Object.class, BuiltInMethod.SCALAR_EXECUTE1.method.getName(), ImmutableList.of(context_), builder.toBlock()));
        ClassDeclaration classDeclaration = Expressions.classDecl(1, "Buzz", null, ImmutableList.of(Scalar.Producer.class), declarations);
        String s = Expressions.toString(declarations, "\n", false);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            Util.debugCode(System.out, s);
        }
        try {
            return JaninoRexCompiler.getScalar(classDeclaration, s);
        }
        catch (IOException | CompileException e) {
            throw new RuntimeException(e);
        }
    }

    static Scalar.Producer getScalar(ClassDeclaration expr, String s) throws CompileException, IOException {
        ICompilerFactory compilerFactory;
        ClassLoader classLoader = Objects.requireNonNull(JaninoRexCompiler.class.getClassLoader(), "classLoader");
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory((ClassLoader)classLoader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
        cbe.setClassName(expr.name);
        cbe.setImplementedInterfaces(new Class[]{Scalar.Producer.class});
        cbe.setParentClassLoader(classLoader);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            cbe.setDebuggingInformation(true, true, true);
        }
        return (Scalar.Producer)cbe.createInstance((Reader)new StringReader(s));
    }
}

