/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.plan.visualizer;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.checkerframework.checker.nullness.qual.Nullable;

class NodeUpdateHelper {
    private final String key;
    private final @Nullable RelNode rel;
    private final NodeUpdateInfo state;
    private @Nullable NodeUpdateInfo update = null;

    NodeUpdateHelper(String key, @Nullable RelNode rel) {
        this.key = key;
        this.rel = rel;
        this.state = new NodeUpdateInfo();
    }

    String getKey() {
        return this.key;
    }

    @Nullable RelNode getRel() {
        return this.rel;
    }

    void updateAttribute(String attr, Object newValue) {
        if (Objects.equals(newValue, this.state.get(attr))) {
            return;
        }
        this.state.put(attr, newValue);
        if (this.update == null) {
            this.update = new NodeUpdateInfo();
        }
        if (newValue instanceof List && ((List)newValue).size() == 0 && !this.update.containsKey(attr)) {
            return;
        }
        this.update.put(attr, newValue);
    }

    boolean isEmptyUpdate() {
        return this.update == null || this.update.isEmpty();
    }

    @Nullable Object getAndResetUpdate() {
        if (this.isEmptyUpdate()) {
            return null;
        }
        NodeUpdateInfo update = this.update;
        this.update = null;
        return update;
    }

    Map<String, Object> getState() {
        return Collections.unmodifiableMap(this.state);
    }

    @Nullable Object getValue(String attr) {
        return this.state.get(attr);
    }

    private static class NodeUpdateInfo
    extends LinkedHashMap<String, Object> {
        private NodeUpdateInfo() {
        }
    }
}

