/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.plan.Contexts;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableJoinCommuteRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.TransformationRule;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexShuttle;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

@Value.Enclosing
public class JoinCommuteRule
extends RelRule<Config>
implements TransformationRule {
    protected JoinCommuteRule(Config config) {
        super(config);
    }

    @Deprecated
    public JoinCommuteRule(Class<? extends Join> clazz, RelBuilderFactory relBuilderFactory, boolean swapOuter) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(clazz).withSwapOuter(swapOuter));
    }

    @Deprecated
    public JoinCommuteRule(Class<? extends Join> clazz, RelFactories.ProjectFactory projectFactory) {
        this(clazz, RelBuilder.proto(Contexts.of((Object)projectFactory)), false);
    }

    @Deprecated
    public JoinCommuteRule(Class<? extends Join> clazz, RelFactories.ProjectFactory projectFactory, boolean swapOuter) {
        this(clazz, RelBuilder.proto(Contexts.of((Object)projectFactory)), swapOuter);
    }

    @Deprecated
    public static @Nullable RelNode swap(Join join) {
        return JoinCommuteRule.swap(join, false, RelFactories.LOGICAL_BUILDER.create(join.getCluster(), null));
    }

    @Deprecated
    public static @Nullable RelNode swap(Join join, boolean swapOuterJoins) {
        return JoinCommuteRule.swap(join, swapOuterJoins, RelFactories.LOGICAL_BUILDER.create(join.getCluster(), null));
    }

    public static @Nullable RelNode swap(Join join, boolean swapOuterJoins, RelBuilder relBuilder) {
        JoinRelType joinType = join.getJoinType();
        if (!swapOuterJoins && joinType != JoinRelType.INNER) {
            return null;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelDataType leftRowType = join.getLeft().getRowType();
        RelDataType rightRowType = join.getRight().getRowType();
        VariableReplacer variableReplacer = new VariableReplacer(rexBuilder, leftRowType, rightRowType);
        RexNode oldCondition = join.getCondition();
        RexNode condition = variableReplacer.apply(oldCondition);
        Join newJoin = join.copy(join.getTraitSet(), condition, join.getRight(), join.getLeft(), joinType.swap(), join.isSemiJoinDone());
        List<RexNode> exps = RelOptUtil.createSwappedJoinExprs(newJoin, join, true);
        return relBuilder.push(newJoin).project(exps, join.getRowType().getFieldNames()).build();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        if (!join.getJoinType().projectsRight()) {
            return false;
        }
        return ((Config)this.config).isAllowAlwaysTrueCondition() || !join.getCondition().isAlwaysTrue();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        RelNode swapped = JoinCommuteRule.swap(join, ((Config)this.config).isSwapOuter(), call.builder());
        if (swapped == null) {
            return;
        }
        Join newJoin = swapped instanceof Join ? (Join)swapped : (Join)swapped.getInput(0);
        call.transformTo(swapped);
        RelBuilder relBuilder = call.builder();
        List<RexNode> exps = RelOptUtil.createSwappedJoinExprs(newJoin, join, false);
        relBuilder.push(swapped).project(exps, newJoin.getRowType().getFieldNames());
        call.getPlanner().ensureRegistered(relBuilder.build(), newJoin);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableJoinCommuteRule.Config.of().withOperandFor(LogicalJoin.class).withSwapOuter(false);

        @Override
        default public JoinCommuteRule toRule() {
            return new JoinCommuteRule(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b -> b.operand(joinClass).predicate(j -> j.getLeft().getId() != j.getRight().getId() && j.getSystemFieldList().isEmpty()).anyInputs()).as(Config.class);
        }

        @Value.Default
        default public boolean isSwapOuter() {
            return false;
        }

        public Config withSwapOuter(boolean var1);

        @Value.Default
        default public boolean isAllowAlwaysTrueCondition() {
            return true;
        }

        public Config withAllowAlwaysTrueCondition(boolean var1);
    }

    private static class VariableReplacer
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final List<RelDataTypeField> leftFields;
        private final List<RelDataTypeField> rightFields;

        VariableReplacer(RexBuilder rexBuilder, RelDataType leftType, RelDataType rightType) {
            this.rexBuilder = rexBuilder;
            this.leftFields = leftType.getFieldList();
            this.rightFields = rightType.getFieldList();
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            int index = inputRef.getIndex();
            if (index < this.leftFields.size()) {
                return this.rexBuilder.makeInputRef(this.leftFields.get(index).getType(), this.rightFields.size() + index);
            }
            if ((index -= this.leftFields.size()) < this.rightFields.size()) {
                return this.rexBuilder.makeInputRef(this.rightFields.get(index).getType(), index);
            }
            throw new AssertionError((Object)("Bad field offset: index=" + inputRef.getIndex() + ", leftFieldCount=" + this.leftFields.size() + ", rightFieldCount=" + this.rightFields.size()));
        }
    }
}

