/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.type;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.hive.druid.com.google.common.collect.ImmutableCollection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableMultimap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.hive.druid.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.hive.druid.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.rel.type.TimeFrame;
import org.apache.hive.druid.org.apache.calcite.rel.type.TimeFrameSet;
import org.apache.hive.druid.org.apache.calcite.util.MonotonicSupplier;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.TimestampString;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TimeFrames {
    public static final List<String> WEEK_FRAME_NAMES = ImmutableList.of("WEEK_SUNDAY", "WEEK_MONDAY", "WEEK_TUESDAY", "WEEK_WEDNESDAY", "WEEK_THURSDAY", "WEEK_FRIDAY", "WEEK_SATURDAY");
    public static final TimeFrameSet CORE = TimeFrames.addTsi(TimeFrames.addCore(new BuilderImpl())).build();

    private TimeFrames() {
    }

    private static BuilderImpl addCore(BuilderImpl b) {
        b.addCore(TimeUnit.SECOND);
        b.addSub(TimeUnit.MINUTE, false, 60, TimeUnit.SECOND);
        b.addSub(TimeUnit.HOUR, false, 60, TimeUnit.MINUTE);
        b.addSub(TimeUnit.DAY, false, 24, TimeUnit.HOUR);
        b.addSub(TimeUnit.WEEK, false, (Number)7, TimeUnit.DAY, new TimestampString(1970, 1, 4, 0, 0, 0));
        b.addSub(TimeUnit.MILLISECOND, true, 1000, TimeUnit.SECOND);
        b.addSub(TimeUnit.MICROSECOND, true, 1000, TimeUnit.MILLISECOND);
        b.addSub(TimeUnit.NANOSECOND, true, 1000, TimeUnit.MICROSECOND);
        b.addSub(TimeUnit.EPOCH, false, (Number)1, TimeUnit.SECOND, new TimestampString(1970, 1, 1, 0, 0, 0));
        b.addCore(TimeUnit.MONTH);
        b.addSub(TimeUnit.QUARTER, false, 3, TimeUnit.MONTH);
        b.addSub(TimeUnit.YEAR, false, 12, TimeUnit.MONTH);
        b.addSub(TimeUnit.DECADE, false, 10, TimeUnit.YEAR);
        b.addSub(TimeUnit.CENTURY, false, (Number)100, TimeUnit.YEAR, new TimestampString(2001, 1, 1, 0, 0, 0));
        b.addSub(TimeUnit.MILLENNIUM, false, (Number)1000, TimeUnit.YEAR, new TimestampString(2001, 1, 1, 0, 0, 0));
        b.addCore(TimeUnit.ISOYEAR);
        b.addSub("ISOWEEK", false, (Number)7, TimeUnit.DAY.name(), new TimestampString(1970, 1, 5, 0, 0, 0));
        Ord.forEach(WEEK_FRAME_NAMES, (frameName, i) -> b.addSub((String)frameName, false, (Number)7, "DAY", new TimestampString(1970, 1, 4 + i, 0, 0, 0)));
        b.addQuotient(TimeUnit.DOY, TimeUnit.DAY, TimeUnit.YEAR);
        b.addQuotient(TimeUnit.DOW, TimeUnit.DAY, TimeUnit.WEEK);
        b.addQuotient(TimeUnit.ISODOW.name(), TimeUnit.DAY.name(), "ISOWEEK");
        b.addRollup(TimeUnit.DAY, TimeUnit.MONTH);
        b.addRollup("ISOWEEK", TimeUnit.ISOYEAR.name());
        return b;
    }

    private static BuilderImpl addTsi(BuilderImpl b) {
        b.addAlias("FRAC_SECOND", TimeUnit.MICROSECOND.name());
        b.addAlias("SQL_TSI_FRAC_SECOND", TimeUnit.NANOSECOND.name());
        b.addAlias("SQL_TSI_MICROSECOND", TimeUnit.MICROSECOND.name());
        b.addAlias("SQL_TSI_SECOND", TimeUnit.SECOND.name());
        b.addAlias("SQL_TSI_MINUTE", TimeUnit.MINUTE.name());
        b.addAlias("SQL_TSI_HOUR", TimeUnit.HOUR.name());
        b.addAlias("SQL_TSI_DAY", TimeUnit.DAY.name());
        b.addAlias("SQL_TSI_WEEK", TimeUnit.WEEK.name());
        b.addAlias("SQL_TSI_MONTH", TimeUnit.MONTH.name());
        b.addAlias("SQL_TSI_QUARTER", TimeUnit.QUARTER.name());
        b.addAlias("SQL_TSI_YEAR", TimeUnit.YEAR.name());
        return b;
    }

    static int floorCeilIsoYear(int date, boolean ceil) {
        int year = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.YEAR, (long)date);
        return (int)TimeFrames.firstMondayOfFirstWeek(year + (ceil ? 1 : 0)) - 2440588;
    }

    static long firstMondayOfFirstWeek(int year) {
        long janFirst = DateTimeUtils.ymdToJulian((int)year, (int)1, (int)1);
        long janFirstDow = Math.floorMod(janFirst + 1L, 7L);
        return janFirst + (11L - janFirstDow) % 7L - 3L;
    }

    static int fullMonth(int year, int month) {
        return year * 12 + (month - 1);
    }

    static int fullMonthToMonth(int fullMonth) {
        return Math.floorMod(fullMonth, 12) + 1;
    }

    static int fullMonthToYear(int fullMonth) {
        return Math.floorDiv(fullMonth, 12);
    }

    static long unixTimestamp(int fullMonth, int day, int hour, int minute, int second) {
        int year = TimeFrames.fullMonthToYear(fullMonth);
        int month = TimeFrames.fullMonthToMonth(fullMonth);
        return DateTimeUtils.unixTimestamp((int)year, (int)month, (int)day, (int)hour, (int)minute, (int)second);
    }

    static int mdToUnixDate(int fullMonth, int day) {
        int year = TimeFrames.fullMonthToYear(fullMonth);
        int month = TimeFrames.fullMonthToMonth(fullMonth);
        return DateTimeUtils.ymdToUnixDate((int)year, (int)month, (int)day);
    }

    private static boolean canDirectlyRollUp(TimeFrameImpl from, TimeFrameImpl to) {
        if (from.core().equals(to.core())) {
            if (TimeFrames.divisible(from.coreMultiplier(), to.coreMultiplier())) {
                BigFraction diff = new BigFraction(from.core().epochDiff(from, to));
                return TimeFrames.divisible(from.coreMultiplier(), diff);
            }
            return false;
        }
        return false;
    }

    private static boolean divisible(BigFraction numerator, BigFraction denominator) {
        return denominator.equals(BigFraction.ZERO) || numerator.divide(denominator).getNumerator().abs().equals(BigInteger.ONE);
    }

    static class AliasFrame
    extends TimeFrameImpl {
        final TimeFrameImpl frame;

        AliasFrame(String name, TimeFrameImpl frame) {
            super(frame.frameSetSupplier, name);
            this.frame = Objects.requireNonNull(frame, "frame");
        }

        @Override
        void replicate(BuilderImpl b) {
            b.addAlias(this.name, this.frame.name);
        }

        @Override
        protected CoreFrame core() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected BigFraction coreMultiplier() {
            throw new UnsupportedOperationException();
        }
    }

    static class QuotientFrame
    extends TimeFrameImpl {
        private final TimeFrameImpl minorFrame;
        private final TimeFrameImpl majorFrame;

        QuotientFrame(String name, TimeFrameImpl minorFrame, TimeFrameImpl majorFrame) {
            super(minorFrame.frameSetSupplier, name);
            this.minorFrame = Objects.requireNonNull(minorFrame, "minorFrame");
            this.majorFrame = Objects.requireNonNull(majorFrame, "majorFrame");
        }

        @Override
        void replicate(BuilderImpl b) {
            b.addQuotient(this.name, this.minorFrame.name, this.majorFrame.name);
        }

        @Override
        protected CoreFrame core() {
            return this.minorFrame.core();
        }

        @Override
        protected BigFraction coreMultiplier() {
            return this.minorFrame.coreMultiplier();
        }
    }

    static class SubFrame
    extends TimeFrameImpl {
        private final TimeFrameImpl base;
        private final boolean divide;
        private final BigInteger multiplier;
        private final CoreFrame coreFrame;
        private final BigFraction coreMultiplier;
        private final TimestampString epoch;

        SubFrame(String name, TimeFrameImpl base, boolean divide, BigInteger multiplier, CoreFrame coreFrame, BigFraction coreMultiplier, TimestampString epoch) {
            super(base.frameSetSupplier, name);
            this.base = Objects.requireNonNull(base, "base");
            this.divide = divide;
            this.multiplier = Objects.requireNonNull(multiplier, "multiplier");
            this.coreFrame = Objects.requireNonNull(coreFrame, "coreFrame");
            this.coreMultiplier = Objects.requireNonNull(coreMultiplier, "coreMultiplier");
            this.epoch = Objects.requireNonNull(epoch, "epoch");
        }

        @Override
        public String toString() {
            return this.name + ", composedOf " + this.multiplier + " " + this.base.name;
        }

        @Override
        public int dateEpoch() {
            return (int)Math.floorDiv(this.epoch.getMillisSinceEpoch(), 86400000L);
        }

        @Override
        public int monthEpoch() {
            Calendar calendar = this.epoch.toCalendar();
            int y = calendar.get(1);
            int m = calendar.get(2) + 1;
            return TimeFrames.fullMonth(y, m);
        }

        @Override
        public long timestampEpoch() {
            return this.epoch.getMillisSinceEpoch();
        }

        @Override
        void replicate(BuilderImpl b) {
            b.addSub(this.name, this.divide, (Number)this.multiplier, this.base.name, this.epoch);
        }

        void replicateWithEpoch(BuilderImpl b, TimestampString epoch) {
            b.addSub(this.name, this.divide, (Number)this.multiplier, this.base.name, epoch);
        }

        @Override
        protected void expand(Map<TimeFrame, BigFraction> map, BigFraction f) {
            super.expand(map, f);
            this.base.expand(map, this.divide ? f.divide(this.multiplier) : f.multiply(this.multiplier));
        }

        @Override
        protected CoreFrame core() {
            return this.coreFrame;
        }

        @Override
        protected BigFraction coreMultiplier() {
            return this.coreMultiplier;
        }
    }

    static class CoreFrame
    extends TimeFrameImpl {
        CoreFrame(Supplier<TimeFrameSet> frameSetSupplier, String name) {
            super(frameSetSupplier, name);
        }

        @Override
        void replicate(BuilderImpl b) {
            b.addCore(this.name);
        }

        @Override
        protected CoreFrame core() {
            return this;
        }

        @Override
        protected BigFraction coreMultiplier() {
            return BigFraction.ONE;
        }

        BigInteger epochDiff(TimeFrameImpl from, TimeFrameImpl to) {
            assert (from.core() == this);
            assert (to.core() == this);
            switch (this.name) {
                case "MONTH": {
                    return BigInteger.valueOf(from.monthEpoch()).subtract(BigInteger.valueOf(to.monthEpoch()));
                }
            }
            return BigInteger.valueOf(from.timestampEpoch()).subtract(BigInteger.valueOf(to.timestampEpoch()));
        }
    }

    static abstract class TimeFrameImpl
    implements TimeFrame {
        final String name;
        final Supplier<TimeFrameSet> frameSetSupplier;

        TimeFrameImpl(Supplier<TimeFrameSet> frameSetSupplier, String name) {
            this.frameSetSupplier = Objects.requireNonNull(frameSetSupplier, "frameSetSupplier");
            this.name = Objects.requireNonNull(name, "name");
        }

        public String toString() {
            return this.name;
        }

        @Override
        public TimeFrameSet frameSet() {
            return this.frameSetSupplier.get();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public @Nullable BigFraction per(TimeFrame timeFrame) {
            HashMap<TimeFrame, BigFraction> map = new HashMap<TimeFrame, BigFraction>();
            HashMap<TimeFrame, BigFraction> map2 = new HashMap<TimeFrame, BigFraction>();
            this.expand(map, BigFraction.ONE);
            ((TimeFrameImpl)timeFrame).expand(map2, BigFraction.ONE);
            HashSet<BigFraction> fractions = new HashSet<BigFraction>();
            for (Map.Entry entry : map.entrySet()) {
                BigFraction value2 = (BigFraction)map2.get(entry.getKey());
                if (value2 == null) continue;
                fractions.add(value2.divide((BigFraction)entry.getValue()));
            }
            switch (fractions.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return (BigFraction)Iterables.getOnlyElement(fractions);
                }
            }
            throw new AssertionError((Object)("inconsistent multipliers for " + this + ".per(" + timeFrame + "): " + fractions));
        }

        protected void expand(Map<TimeFrame, BigFraction> map, BigFraction f) {
            map.put(this, f);
        }

        abstract void replicate(BuilderImpl var1);

        protected abstract CoreFrame core();

        protected abstract BigFraction coreMultiplier();

        @Override
        public boolean canRollUpTo(TimeFrame toFrame) {
            if (toFrame == this) {
                return true;
            }
            if (toFrame instanceof TimeFrameImpl) {
                TimeFrameImpl toFrame1 = (TimeFrameImpl)toFrame;
                if (TimeFrames.canDirectlyRollUp(this, toFrame1)) {
                    return true;
                }
                TimeFrameSet frameSet = this.frameSet();
                if (((ImmutableCollection)frameSet.rollupMap.entries()).contains(Pair.of(this, toFrame1))) {
                    return true;
                }
                TimeFrameImpl day = Objects.requireNonNull(frameSet.map.get(TimeUnit.DAY.name()));
                TimeFrameImpl month = Objects.requireNonNull(frameSet.map.get(TimeUnit.MONTH.name()));
                if (TimeFrames.canDirectlyRollUp(this, day) && TimeFrames.canDirectlyRollUp(month, toFrame1)) {
                    return true;
                }
                TimeFrameImpl isoYear = Objects.requireNonNull(frameSet.map.get(TimeUnit.ISOYEAR.name()));
                TimeFrameImpl isoWeek = Objects.requireNonNull(frameSet.map.get("ISOWEEK"));
                if (TimeFrames.canDirectlyRollUp(this, isoWeek) && TimeFrames.canDirectlyRollUp(isoYear, toFrame1)) {
                    return true;
                }
            }
            return false;
        }
    }

    static class BuilderImpl
    implements TimeFrameSet.Builder {
        final MonotonicSupplier<TimeFrameSet> frameSetSupplier = new MonotonicSupplier();
        final Map<String, TimeFrameImpl> map = new LinkedHashMap<String, TimeFrameImpl>();
        final ImmutableMultimap.Builder<TimeFrameImpl, TimeFrameImpl> rollupList = ImmutableMultimap.builder();

        BuilderImpl() {
        }

        @Override
        public TimeFrameSet build() {
            TimeFrameSet frameSet = new TimeFrameSet(ImmutableMap.copyOf(this.map), this.rollupList.build());
            this.frameSetSupplier.accept(frameSet);
            return frameSet;
        }

        static BigInteger toBigInteger(Number number) {
            return number instanceof BigInteger ? (BigInteger)number : BigInteger.valueOf(number.longValue());
        }

        TimeFrameImpl getFrame(String name) {
            TimeFrameImpl timeFrame = this.map.get(name);
            if (timeFrame == null) {
                throw new IllegalArgumentException("unknown frame: " + name);
            }
            return timeFrame;
        }

        private BuilderImpl addFrame(String name, TimeFrameImpl frame) {
            TimeFrameImpl previousFrame = this.map.put(name, Objects.requireNonNull(frame, "frame"));
            if (previousFrame != null) {
                this.map.put(name, previousFrame);
                throw new IllegalArgumentException("duplicate frame: " + name);
            }
            return this;
        }

        @Override
        public BuilderImpl addCore(String name) {
            return this.addFrame(name, new CoreFrame(this.frameSetSupplier, name));
        }

        BuilderImpl addSub(String name, boolean divide, Number count, String baseName, TimestampString epoch) {
            TimeFrameImpl baseFrame = this.getFrame(baseName);
            BigInteger factor = BuilderImpl.toBigInteger(count);
            CoreFrame coreFrame = baseFrame.core();
            BigFraction coreFactor = divide ? baseFrame.coreMultiplier().divide(factor) : baseFrame.coreMultiplier().multiply(factor);
            return this.addFrame(name, new SubFrame(name, baseFrame, divide, factor, coreFrame, coreFactor, epoch));
        }

        @Override
        public BuilderImpl addQuotient(String name, String minorName, String majorName) {
            TimeFrameImpl minorFrame = this.getFrame(minorName);
            TimeFrameImpl majorFrame = this.getFrame(majorName);
            return this.addFrame(name, new QuotientFrame(name, minorFrame, majorFrame));
        }

        @Override
        public BuilderImpl addMultiple(String name, Number count, String baseName) {
            return this.addSub(name, false, count, baseName, TimestampString.EPOCH);
        }

        @Override
        public BuilderImpl addDivision(String name, Number count, String baseName) {
            return this.addSub(name, true, count, baseName, TimestampString.EPOCH);
        }

        @Override
        public BuilderImpl addRollup(String fromName, String toName) {
            TimeFrameImpl fromFrame = this.getFrame(fromName);
            TimeFrameImpl toFrame = this.getFrame(toName);
            this.rollupList.put(fromFrame, toFrame);
            return this;
        }

        @Override
        public BuilderImpl addAll(TimeFrameSet timeFrameSet) {
            timeFrameSet.map.values().forEach(frame -> frame.replicate(this));
            return this;
        }

        @Override
        public BuilderImpl withEpoch(TimestampString epoch) {
            Map.Entry<String, TimeFrameImpl> entry = Iterables.getLast(this.map.entrySet());
            String name = entry.getKey();
            SubFrame value = Objects.requireNonNull((SubFrame)this.map.remove(name));
            value.replicateWithEpoch(this, epoch);
            return this;
        }

        @Override
        public BuilderImpl addAlias(String name, String originalName) {
            TimeFrameImpl frame = this.getFrame(originalName);
            return this.addFrame(name, new AliasFrame(name, frame));
        }

        void addCore(TimeUnit unit) {
            this.addCore(unit.name());
        }

        void addSub(TimeUnit unit, boolean divide, Number count, TimeUnit baseUnit) {
            this.addSub(unit, divide, count, baseUnit, TimestampString.EPOCH);
        }

        void addSub(TimeUnit unit, boolean divide, Number count, TimeUnit baseUnit, TimestampString epoch) {
            this.addSub(unit.name(), divide, count, baseUnit.name(), epoch);
        }

        void addRollup(TimeUnit fromUnit, TimeUnit toUnit) {
            this.addRollup(fromUnit.name(), toUnit.name());
        }

        void addQuotient(TimeUnit unit, TimeUnit minor, TimeUnit major) {
            this.addQuotient(unit.name(), minor.name(), major.name());
        }
    }
}

