/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apiguardian.api.API;

public enum SqlKind {
    OTHER,
    SELECT,
    HINT,
    TABLE_REF,
    JOIN,
    IDENTIFIER,
    LITERAL,
    INTERVAL_QUALIFIER,
    OTHER_FUNCTION,
    SET_SEMANTICS_TABLE,
    POSITION,
    EXPLAIN,
    DESCRIBE_SCHEMA,
    DESCRIBE_TABLE,
    INSERT,
    DELETE,
    UPDATE,
    SET_OPTION,
    DYNAMIC_PARAM,
    GROUP_BY_DISTINCT,
    ORDER_BY,
    WITH,
    WITH_ITEM,
    ITEM,
    UNION,
    EXCEPT,
    INTERSECT,
    AS,
    ARGUMENT_ASSIGNMENT,
    DEFAULT,
    OVER,
    RESPECT_NULLS("RESPECT NULLS"),
    IGNORE_NULLS("IGNORE NULLS"),
    FILTER,
    WITHIN_GROUP,
    WITHIN_DISTINCT,
    WINDOW,
    MERGE,
    TABLESAMPLE,
    PIVOT,
    UNPIVOT,
    MATCH_RECOGNIZE,
    SNAPSHOT,
    TIMES,
    DIVIDE,
    MOD,
    PLUS,
    MINUS,
    PATTERN_ALTER,
    PATTERN_CONCAT,
    IN,
    NOT_IN("NOT IN"),
    DRUID_IN,
    DRUID_NOT_IN,
    LESS_THAN("<"),
    GREATER_THAN(">"),
    LESS_THAN_OR_EQUAL("<="),
    GREATER_THAN_OR_EQUAL(">="),
    EQUALS("="),
    NOT_EQUALS("<>"),
    IS_DISTINCT_FROM,
    IS_NOT_DISTINCT_FROM,
    SEARCH,
    OR,
    AND,
    DOT,
    OVERLAPS,
    CONTAINS,
    PRECEDES,
    IMMEDIATELY_PRECEDES("IMMEDIATELY PRECEDES"),
    SUCCEEDS,
    IMMEDIATELY_SUCCEEDS("IMMEDIATELY SUCCEEDS"),
    PERIOD_EQUALS("EQUALS"),
    LIKE,
    RLIKE,
    SIMILAR,
    POSIX_REGEX_CASE_SENSITIVE,
    POSIX_REGEX_CASE_INSENSITIVE,
    BETWEEN,
    DRUID_BETWEEN,
    CASE,
    INTERVAL,
    SEPARATOR,
    NULLIF,
    COALESCE,
    DECODE,
    NVL,
    GREATEST,
    CONCAT2,
    IF,
    LEAST,
    DATE_SUB,
    TIME_ADD,
    TIME_SUB,
    TIMESTAMP_ADD,
    TIMESTAMP_DIFF,
    TIMESTAMP_SUB,
    NOT,
    PLUS_PREFIX,
    MINUS_PREFIX,
    EXISTS,
    SOME,
    ALL,
    VALUES,
    EXPLICIT_TABLE,
    SCALAR_QUERY,
    PROCEDURE_CALL,
    NEW_SPECIFICATION,
    FINAL,
    RUNNING,
    PREV,
    NEXT,
    FIRST,
    LAST,
    CLASSIFIER,
    MATCH_NUMBER,
    SKIP_TO_FIRST,
    SKIP_TO_LAST,
    DESCENDING,
    NULLS_FIRST,
    NULLS_LAST,
    IS_TRUE,
    IS_FALSE,
    IS_NOT_TRUE,
    IS_NOT_FALSE,
    IS_UNKNOWN,
    IS_NULL,
    IS_NOT_NULL,
    PRECEDING,
    FOLLOWING,
    FIELD_ACCESS,
    INPUT_REF,
    TABLE_INPUT_REF,
    PATTERN_INPUT_REF,
    LOCAL_REF,
    CORREL_VARIABLE,
    PATTERN_QUANTIFIER,
    ROW,
    COLUMN_LIST,
    CAST,
    NEXT_VALUE,
    CURRENT_VALUE,
    FLOOR,
    CEIL,
    TRIM,
    LTRIM,
    RTRIM,
    EXTRACT,
    ARRAY_CONCAT,
    ARRAY_REVERSE,
    REVERSE,
    SUBSTR_BIG_QUERY,
    SUBSTR_MYSQL,
    SUBSTR_ORACLE,
    SUBSTR_POSTGRESQL,
    JDBC_FN,
    MULTISET_VALUE_CONSTRUCTOR,
    MULTISET_QUERY_CONSTRUCTOR,
    JSON_VALUE_EXPRESSION,
    JSON_ARRAYAGG,
    JSON_OBJECTAGG,
    JSON_TYPE,
    UNNEST,
    LATERAL,
    COLLECTION_TABLE,
    ARRAY_VALUE_CONSTRUCTOR,
    ARRAY_QUERY_CONSTRUCTOR,
    MAP_VALUE_CONSTRUCTOR,
    MAP_QUERY_CONSTRUCTOR,
    CURSOR,
    LITERAL_CHAIN,
    ESCAPE,
    REINTERPRET,
    EXTEND,
    CUBE,
    ROLLUP,
    GROUPING_SETS,
    GROUPING,
    GROUPING_ID,
    GROUP_ID,
    PATTERN_PERMUTE,
    PATTERN_EXCLUDED,
    COUNT,
    SUM,
    SUM0,
    MIN,
    MAX,
    LEAD,
    LAG,
    FIRST_VALUE,
    LAST_VALUE,
    ANY_VALUE,
    COVAR_POP,
    COVAR_SAMP,
    REGR_COUNT,
    REGR_SXX,
    REGR_SYY,
    AVG,
    STDDEV_POP,
    STDDEV_SAMP,
    VAR_POP,
    VAR_SAMP,
    NTILE,
    NTH_VALUE,
    LISTAGG,
    STRING_AGG,
    COUNTIF,
    ARRAY_AGG,
    ARRAY_CONCAT_AGG,
    GROUP_CONCAT,
    COLLECT,
    MODE,
    ARG_MAX,
    ARG_MIN,
    PERCENTILE_CONT,
    PERCENTILE_DISC,
    FUSION,
    INTERSECTION,
    SINGLE_VALUE,
    AGGREGATE_FN,
    BIT_AND,
    BIT_OR,
    BIT_XOR,
    ROW_NUMBER,
    RANK,
    PERCENT_RANK,
    DENSE_RANK,
    CUME_DIST,
    DESCRIPTOR,
    TUMBLE,
    TUMBLE_START,
    TUMBLE_END,
    HOP,
    HOP_START,
    HOP_END,
    SESSION,
    SESSION_START,
    SESSION_END,
    COLUMN_DECL,
    ATTRIBUTE_DEF,
    CHECK,
    UNIQUE,
    PRIMARY_KEY,
    FOREIGN_KEY,
    ST_DWITHIN,
    ST_POINT,
    ST_POINT3,
    ST_MAKE_LINE,
    ST_CONTAINS,
    HILBERT,
    COMMIT,
    ROLLBACK,
    ALTER_SESSION,
    CREATE_SCHEMA,
    CREATE_FOREIGN_SCHEMA,
    DROP_SCHEMA,
    CREATE_TABLE,
    ALTER_TABLE,
    DROP_TABLE,
    CREATE_VIEW,
    ALTER_VIEW,
    DROP_VIEW,
    CREATE_MATERIALIZED_VIEW,
    ALTER_MATERIALIZED_VIEW,
    DROP_MATERIALIZED_VIEW,
    CREATE_SEQUENCE,
    ALTER_SEQUENCE,
    DROP_SEQUENCE,
    CREATE_INDEX,
    ALTER_INDEX,
    DROP_INDEX,
    CREATE_TYPE,
    DROP_TYPE,
    CREATE_FUNCTION,
    DROP_FUNCTION,
    OTHER_DDL;

    public static final EnumSet<SqlKind> SET_QUERY;
    public static final EnumSet<SqlKind> AGGREGATE;
    public static final EnumSet<SqlKind> DML;
    public static final EnumSet<SqlKind> DDL;
    public static final EnumSet<SqlKind> QUERY;
    public static final Set<SqlKind> EXPRESSION;
    public static final EnumSet<SqlKind> TOP_LEVEL;
    public static final Set<SqlKind> FUNCTION;
    public static final Set<SqlKind> AVG_AGG_FUNCTIONS;
    public static final Set<SqlKind> COVAR_AVG_AGG_FUNCTIONS;
    public static final Set<SqlKind> COMPARISON;
    public static final Set<SqlKind> BINARY_ARITHMETIC;
    public static final Set<SqlKind> BINARY_EQUALITY;
    public static final Set<SqlKind> BINARY_COMPARISON;
    @API(since="1.22", status=API.Status.EXPERIMENTAL)
    public static final Set<SqlKind> SYMMETRICAL;
    @API(since="1.22", status=API.Status.EXPERIMENTAL)
    public static final Set<SqlKind> SYMMETRICAL_SAME_ARG_TYPE;
    @API(since="1.24", status=API.Status.EXPERIMENTAL)
    public static final Set<SqlKind> SIMPLE_BINARY_OPS;
    public final String lowerName = this.name().toLowerCase(Locale.ROOT);
    public final String sql;

    private SqlKind() {
        this.sql = this.name();
    }

    private SqlKind(String sql) {
        this.sql = sql;
    }

    public SqlKind reverse() {
        switch (this) {
            case GREATER_THAN: {
                return LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return GREATER_THAN_OR_EQUAL;
            }
        }
        return this;
    }

    public SqlKind negate() {
        switch (this) {
            case IS_TRUE: {
                return IS_NOT_TRUE;
            }
            case IS_FALSE: {
                return IS_NOT_FALSE;
            }
            case IS_NULL: {
                return IS_NOT_NULL;
            }
            case IS_NOT_TRUE: {
                return IS_TRUE;
            }
            case IS_NOT_FALSE: {
                return IS_FALSE;
            }
            case IS_NOT_NULL: {
                return IS_NULL;
            }
            case IS_DISTINCT_FROM: {
                return IS_NOT_DISTINCT_FROM;
            }
            case IS_NOT_DISTINCT_FROM: {
                return IS_DISTINCT_FROM;
            }
        }
        return this;
    }

    public SqlKind negateNullSafe() {
        switch (this) {
            case EQUALS: {
                return NOT_EQUALS;
            }
            case NOT_EQUALS: {
                return EQUALS;
            }
            case LESS_THAN: {
                return GREATER_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN_OR_EQUAL: {
                return GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return LESS_THAN;
            }
            case IN: {
                return NOT_IN;
            }
            case NOT_IN: {
                return IN;
            }
            case DRUID_IN: {
                return DRUID_NOT_IN;
            }
            case DRUID_NOT_IN: {
                return DRUID_IN;
            }
            case IS_TRUE: {
                return IS_FALSE;
            }
            case IS_FALSE: {
                return IS_TRUE;
            }
            case IS_NOT_TRUE: {
                return IS_NOT_FALSE;
            }
            case IS_NOT_FALSE: {
                return IS_NOT_TRUE;
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                return this;
            }
        }
        return this.negate();
    }

    public final boolean belongsTo(Collection<SqlKind> category) {
        return category.contains((Object)this);
    }

    @SafeVarargs
    private static <E extends Enum<E>> EnumSet<E> concat(EnumSet<E> set0, EnumSet<E> ... sets) {
        Object set = set0.clone();
        for (EnumSet<E> s : sets) {
            ((AbstractCollection)set).addAll(s);
        }
        return set;
    }

    static {
        SET_QUERY = EnumSet.of(UNION, INTERSECT, EXCEPT);
        AGGREGATE = EnumSet.of(COUNT, new SqlKind[]{SUM, SUM0, MIN, MAX, LEAD, LAG, FIRST_VALUE, LAST_VALUE, COVAR_POP, COVAR_SAMP, REGR_COUNT, REGR_SXX, REGR_SYY, AVG, STDDEV_POP, STDDEV_SAMP, VAR_POP, VAR_SAMP, NTILE, COLLECT, MODE, FUSION, SINGLE_VALUE, ROW_NUMBER, RANK, PERCENT_RANK, DENSE_RANK, CUME_DIST, JSON_ARRAYAGG, JSON_OBJECTAGG, BIT_AND, BIT_OR, BIT_XOR, LISTAGG, STRING_AGG, ARRAY_AGG, ARRAY_CONCAT_AGG, GROUP_CONCAT, COUNTIF, PERCENTILE_CONT, PERCENTILE_DISC, INTERSECTION, ANY_VALUE});
        DML = EnumSet.of(INSERT, DELETE, UPDATE, MERGE, PROCEDURE_CALL);
        DDL = EnumSet.of(COMMIT, new SqlKind[]{ROLLBACK, ALTER_SESSION, CREATE_SCHEMA, CREATE_FOREIGN_SCHEMA, DROP_SCHEMA, CREATE_TABLE, ALTER_TABLE, DROP_TABLE, CREATE_FUNCTION, DROP_FUNCTION, CREATE_VIEW, ALTER_VIEW, DROP_VIEW, CREATE_MATERIALIZED_VIEW, ALTER_MATERIALIZED_VIEW, DROP_MATERIALIZED_VIEW, CREATE_SEQUENCE, ALTER_SEQUENCE, DROP_SEQUENCE, CREATE_INDEX, ALTER_INDEX, DROP_INDEX, CREATE_TYPE, DROP_TYPE, SET_OPTION, OTHER_DDL});
        QUERY = EnumSet.of(SELECT, new SqlKind[]{UNION, INTERSECT, EXCEPT, VALUES, WITH, ORDER_BY, EXPLICIT_TABLE});
        EXPRESSION = EnumSet.complementOf(SqlKind.concat(EnumSet.of(AS, new SqlKind[]{ARGUMENT_ASSIGNMENT, DEFAULT, RUNNING, FINAL, LAST, FIRST, PREV, NEXT, FILTER, WITHIN_GROUP, IGNORE_NULLS, RESPECT_NULLS, SEPARATOR, DESCENDING, CUBE, ROLLUP, GROUPING_SETS, EXTEND, LATERAL, SELECT, JOIN, OTHER_FUNCTION, POSITION, CAST, TRIM, FLOOR, CEIL, DATE_SUB, TIME_ADD, TIME_SUB, TIMESTAMP_ADD, TIMESTAMP_DIFF, TIMESTAMP_SUB, EXTRACT, INTERVAL, LITERAL_CHAIN, JDBC_FN, PRECEDING, FOLLOWING, ORDER_BY, NULLS_FIRST, NULLS_LAST, COLLECTION_TABLE, TABLESAMPLE, VALUES, WITH, WITH_ITEM, ITEM, SKIP_TO_FIRST, SKIP_TO_LAST, JSON_VALUE_EXPRESSION, UNNEST}), SET_QUERY, AGGREGATE, DML, DDL));
        TOP_LEVEL = SqlKind.concat(QUERY, DML, DDL);
        FUNCTION = EnumSet.of(OTHER_FUNCTION, new SqlKind[]{ROW, TRIM, LTRIM, RTRIM, CAST, REVERSE, JDBC_FN, POSITION});
        AVG_AGG_FUNCTIONS = EnumSet.of(AVG, STDDEV_POP, STDDEV_SAMP, VAR_POP, VAR_SAMP);
        COVAR_AVG_AGG_FUNCTIONS = EnumSet.of(COVAR_POP, COVAR_SAMP, REGR_COUNT, REGR_SXX, REGR_SYY);
        COMPARISON = EnumSet.of(IN, new SqlKind[]{EQUALS, NOT_EQUALS, LESS_THAN, GREATER_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL});
        BINARY_ARITHMETIC = EnumSet.of(PLUS, MINUS, TIMES, DIVIDE, MOD);
        BINARY_EQUALITY = EnumSet.of(EQUALS, NOT_EQUALS);
        BINARY_COMPARISON = EnumSet.of(EQUALS, new SqlKind[]{NOT_EQUALS, GREATER_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN, LESS_THAN_OR_EQUAL, IS_DISTINCT_FROM, IS_NOT_DISTINCT_FROM});
        SYMMETRICAL = EnumSet.of(AND, new SqlKind[]{OR, EQUALS, NOT_EQUALS, IS_DISTINCT_FROM, IS_NOT_DISTINCT_FROM, GREATEST, LEAST});
        SYMMETRICAL_SAME_ARG_TYPE = EnumSet.of(PLUS, TIMES);
        EnumSet<SqlKind> kinds = EnumSet.copyOf(BINARY_ARITHMETIC);
        kinds.remove((Object)MOD);
        kinds.addAll(BINARY_COMPARISON);
        SIMPLE_BINARY_OPS = Sets.immutableEnumSet(kinds);
    }
}

