/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.ddl;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDrop;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlLiteral;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;

public class SqlDropSchema
extends SqlDrop {
    private final boolean foreign;
    public final SqlIdentifier name;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP SCHEMA", SqlKind.DROP_SCHEMA);

    SqlDropSchema(SqlParserPos pos, boolean foreign, boolean ifExists, SqlIdentifier name) {
        super(OPERATOR, pos, ifExists);
        this.foreign = foreign;
        this.name = name;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(SqlLiteral.createBoolean(this.foreign, SqlParserPos.ZERO), this.name);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        if (this.foreign) {
            writer.keyword("FOREIGN");
        }
        writer.keyword("SCHEMA");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }
}

