/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.fun;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.config.CalciteSystemProperty;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAggFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSplittableAggFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSyntax;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.util.Optionality;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlCountAggFunction
extends SqlAggFunction {
    public SqlCountAggFunction(String name) {
        this(name, CalciteSystemProperty.STRICT.value() != false ? OperandTypes.ANY : OperandTypes.ONE_OR_MORE);
    }

    public SqlCountAggFunction(String name, SqlOperandTypeChecker sqlOperandTypeChecker) {
        super(name, null, SqlKind.COUNT, ReturnTypes.BIGINT, null, sqlOperandTypeChecker, SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION_STAR;
    }

    @Override
    public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
        return ImmutableList.of(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true));
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return typeFactory.createSqlType(SqlTypeName.BIGINT);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        if (call.isCountStar()) {
            return validator.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
        }
        return super.deriveType(validator, scope, call);
    }

    @Override
    public <T> @Nullable T unwrap(Class<T> clazz) {
        if (clazz == SqlSplittableAggFunction.class) {
            return clazz.cast(SqlSplittableAggFunction.CountSplitter.INSTANCE);
        }
        return super.unwrap(clazz);
    }

    @Override
    public SqlAggFunction getRollup() {
        return SqlStdOperatorTable.SUM0;
    }
}

