/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.fun;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.type.InferTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.util.Static;

public class SqlDatePartFunction
extends SqlFunction {
    private final TimeUnit timeUnit;

    public SqlDatePartFunction(String name, TimeUnit timeUnit) {
        super(name, SqlKind.OTHER, ReturnTypes.BIGINT_NULLABLE, InferTypes.FIRST_KNOWN, OperandTypes.DATETIME, SqlFunctionCategory.TIMEDATE);
        this.timeUnit = timeUnit;
    }

    @Override
    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        if (operands.size() != 1) {
            throw validator.newValidationError(call, Static.RESOURCE.invalidArgCount(this.getName(), 1));
        }
        SqlParserPos pos = call.getParserPosition();
        return SqlStdOperatorTable.EXTRACT.createCall(pos, new SqlIntervalQualifier(this.timeUnit, null, SqlParserPos.ZERO), operands.get(0));
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(1);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (1 == operandsCount);
        return "{0}({1})";
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return OperandTypes.DATETIME.checkOperandTypes(callBinding, throwOnFailure);
    }
}

