/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.fun;

import java.util.Locale;
import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlLiteral;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlJsonObjectFunction
extends SqlFunction {
    public SqlJsonObjectFunction() {
        super("JSON_OBJECT", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000, (SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) -> {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = i == 0 ? typeFactory.createSqlType(SqlTypeName.SYMBOL) : (i % 2 == 1 ? typeFactory.createSqlType(SqlTypeName.VARCHAR) : typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true));
            }
        }, null, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(1);
    }

    @Override
    protected void checkOperandCount(SqlValidator validator, @Nullable SqlOperandTypeChecker argType, SqlCall call) {
        assert (call.operandCount() % 2 == 1);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int count = callBinding.getOperandCount();
        for (int i = 1; i < count; i += 2) {
            RelDataType nameType = callBinding.getOperandType(i);
            if (!SqlTypeUtil.inCharFamily(nameType)) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.expectedCharacter());
                }
                return false;
            }
            if (!nameType.isNullable()) continue;
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.argumentMustNotBeNull(callBinding.operand(i).toString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        if (operands[0] == null) {
            operands[0] = SqlLiteral.createSymbol(SqlJsonConstructorNullClause.NULL_ON_NULL, pos);
        }
        return super.createCall(functionQualifier, pos, operands);
    }

    @Override
    public @Nullable String getSignatureTemplate(int operandsCount) {
        assert (operandsCount % 2 == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("{0}(");
        for (int i = 1; i < operandsCount; ++i) {
            sb.append(String.format(Locale.ROOT, "{%d} ", i + 1));
        }
        sb.append("{1})");
        return sb.toString();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() % 2 == 1);
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        SqlWriter.Frame listFrame = writer.startList("", "");
        for (int i = 1; i < call.operandCount(); i += 2) {
            writer.sep(",");
            writer.keyword("KEY");
            ((SqlNode)call.operand(i)).unparse(writer, leftPrec, rightPrec);
            writer.keyword("VALUE");
            ((SqlNode)call.operand(i + 1)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(listFrame);
        SqlJsonConstructorNullClause nullClause = (SqlJsonConstructorNullClause)((Object)SqlJsonObjectFunction.getEnumValue(call.operand(0)));
        writer.keyword(nullClause.sql);
        writer.endFunCall(frame);
    }

    private static <E extends Enum<E>> E getEnumValue(SqlNode operand) {
        return (E)((Enum)Objects.requireNonNull(((SqlLiteral)operand).getValue(), "operand.value"));
    }
}

