/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.fun;

import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import org.apache.hive.druid.org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlLiteral;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeTransforms;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlJsonQueryFunction
extends SqlFunction {
    public SqlJsonQueryFunction() {
        super("JSON_QUERY", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000.andThen(SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
    }

    @Override
    public @Nullable String getSignatureTemplate(int operandsCount) {
        return "{0}({1} {2} {3} WRAPPER {4} ON EMPTY {5} ON ERROR)";
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep(",", true);
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        SqlJsonQueryWrapperBehavior wrapperBehavior = (SqlJsonQueryWrapperBehavior)((Object)SqlJsonQueryFunction.getEnumValue(call.operand(2)));
        switch (wrapperBehavior) {
            case WITHOUT_ARRAY: {
                writer.keyword("WITHOUT ARRAY");
                break;
            }
            case WITH_CONDITIONAL_ARRAY: {
                writer.keyword("WITH CONDITIONAL ARRAY");
                break;
            }
            case WITH_UNCONDITIONAL_ARRAY: {
                writer.keyword("WITH UNCONDITIONAL ARRAY");
                break;
            }
            default: {
                throw new IllegalStateException("unreachable code");
            }
        }
        writer.keyword("WRAPPER");
        SqlJsonQueryFunction.unparseEmptyOrErrorBehavior(writer, (SqlJsonQueryEmptyOrErrorBehavior)((Object)SqlJsonQueryFunction.getEnumValue(call.operand(3))));
        writer.keyword("ON EMPTY");
        SqlJsonQueryFunction.unparseEmptyOrErrorBehavior(writer, (SqlJsonQueryEmptyOrErrorBehavior)((Object)SqlJsonQueryFunction.getEnumValue(call.operand(4))));
        writer.keyword("ON ERROR");
        writer.endFunCall(frame);
    }

    @Override
    public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        if (operands[2] == null) {
            operands[2] = SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, pos);
        }
        if (operands[3] == null) {
            operands[3] = SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.NULL, pos);
        }
        if (operands[4] == null) {
            operands[4] = SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.NULL, pos);
        }
        return super.createCall(functionQualifier, pos, operands);
    }

    private static void unparseEmptyOrErrorBehavior(SqlWriter writer, SqlJsonQueryEmptyOrErrorBehavior emptyBehavior) {
        switch (emptyBehavior) {
            case NULL: {
                writer.keyword("NULL");
                break;
            }
            case ERROR: {
                writer.keyword("ERROR");
                break;
            }
            case EMPTY_ARRAY: {
                writer.keyword("EMPTY ARRAY");
                break;
            }
            case EMPTY_OBJECT: {
                writer.keyword("EMPTY OBJECT");
                break;
            }
            default: {
                throw new IllegalStateException("unreachable code");
            }
        }
    }

    private static <E extends Enum<E>> E getEnumValue(SqlNode operand) {
        return (E)((Enum)Objects.requireNonNull(((SqlLiteral)operand).getValue(), "operand.value"));
    }
}

