/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.fun;

import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlMultisetValueConstructor;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Static;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlMapValueConstructor
extends SqlMultisetValueConstructor {
    public SqlMapValueConstructor() {
        super("MAP", SqlKind.MAP_VALUE_CONSTRUCTOR);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        Pair<@Nullable RelDataType, @Nullable RelDataType> type = SqlMapValueConstructor.getComponentTypes(opBinding.getTypeFactory(), opBinding.collectOperandTypes());
        return SqlTypeUtil.createMapType(opBinding.getTypeFactory(), (RelDataType)Objects.requireNonNull(type.left, "inferred key type"), (RelDataType)Objects.requireNonNull(type.right, "inferred value type"), false);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<RelDataType> argTypes = SqlTypeUtil.deriveType(callBinding, callBinding.operands());
        if (argTypes.size() == 0) {
            throw callBinding.newValidationError(Static.RESOURCE.mapRequiresTwoOrMoreArgs());
        }
        if (argTypes.size() % 2 > 0) {
            throw callBinding.newValidationError(Static.RESOURCE.mapRequiresEvenArgCount());
        }
        Pair<@Nullable RelDataType, @Nullable RelDataType> componentType = SqlMapValueConstructor.getComponentTypes(callBinding.getTypeFactory(), argTypes);
        if (null == componentType.left || null == componentType.right) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            return false;
        }
        return true;
    }

    private static Pair<@Nullable RelDataType, @Nullable RelDataType> getComponentTypes(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        return Pair.of(typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 0)), typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 1)));
    }
}

