/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.type;

import java.util.List;
import java.util.function.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableCollection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlUtil;
import org.apache.hive.druid.org.apache.calcite.sql.type.ImplicitCastOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hive.druid.org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.hive.druid.org.apache.calcite.util.Static;

public class FamilyOperandTypeChecker
implements SqlSingleOperandTypeChecker,
ImplicitCastOperandTypeChecker {
    protected final ImmutableList<SqlTypeFamily> families;
    protected final Predicate<Integer> optional;

    FamilyOperandTypeChecker(List<SqlTypeFamily> families, Predicate<Integer> optional) {
        this.families = ImmutableList.copyOf(families);
        this.optional = optional;
    }

    @Override
    public boolean isOptional(int i) {
        return this.optional.test(i);
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
        SqlTypeFamily family = (SqlTypeFamily)this.families.get(iFormalOperand);
        switch (family) {
            case ANY: {
                RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
                SqlTypeName typeName = type.getSqlTypeName();
                if (typeName == SqlTypeName.CURSOR) {
                    if (throwOnFailure) {
                        throw callBinding.newValidationSignatureError();
                    }
                    return false;
                }
            }
            case IGNORE: {
                return true;
            }
        }
        if (SqlUtil.isNullLiteral(node, false)) {
            if (callBinding.isTypeCoercionEnabled()) {
                return true;
            }
            if (throwOnFailure) {
                throw callBinding.getValidator().newValidationError(node, Static.RESOURCE.nullIllegal());
            }
            return false;
        }
        RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName.getFamily() == SqlTypeFamily.ANY) {
            return true;
        }
        if (!family.getTypeNames().contains((Object)typeName)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (this.families.size() != callBinding.getOperandCount()) {
            return false;
        }
        for (Ord<SqlNode> op : Ord.zip(callBinding.operands())) {
            if (this.checkSingleOperandType(callBinding, (SqlNode)op.e, op.i, false)) continue;
            boolean coerced = false;
            if (callBinding.isTypeCoercionEnabled()) {
                TypeCoercion typeCoercion = callBinding.getValidator().getTypeCoercion();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < callBinding.getOperandCount(); ++i) {
                    builder.add(callBinding.getOperandType(i));
                }
                ImmutableCollection dataTypes = builder.build();
                coerced = typeCoercion.builtinFunctionCoercion(callBinding, (List<RelDataType>)((Object)dataTypes), this.families);
            }
            for (Ord<SqlNode> op1 : Ord.zip(callBinding.operands())) {
                if (this.checkSingleOperandType(callBinding, (SqlNode)op1.e, op1.i, throwOnFailure)) continue;
                return false;
            }
            return coerced;
        }
        return true;
    }

    @Override
    public boolean checkOperandTypesWithoutTypeCoercion(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (this.families.size() != callBinding.getOperandCount()) {
            return false;
        }
        for (Ord<SqlNode> op : Ord.zip(callBinding.operands())) {
            if (this.checkSingleOperandType(callBinding, (SqlNode)op.e, op.i, throwOnFailure)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SqlTypeFamily getOperandSqlTypeFamily(int iFormalOperand) {
        return (SqlTypeFamily)this.families.get(iFormalOperand);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        int max;
        int min;
        for (min = max = this.families.size(); min > 0 && this.optional.test(min - 1); --min) {
        }
        return SqlOperandCountRanges.between(min, max);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return SqlUtil.getAliasedSignature(op, opName, this.families);
    }
}

