/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.validate;

import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.util.Static;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SetopNamespace
extends AbstractNamespace {
    private final SqlCall call;

    protected SetopNamespace(SqlValidatorImpl validator, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.call = call;
    }

    @Override
    public @Nullable SqlNode getNode() {
        return this.call;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        SqlMonotonicity monotonicity = null;
        int index = this.getRowType().getFieldNames().indexOf(columnName);
        if (index < 0) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        for (SqlNode operand : this.call.getOperandList()) {
            SqlValidatorNamespace namespace = Objects.requireNonNull(this.validator.getNamespace(operand), () -> "namespace for " + operand);
            monotonicity = SetopNamespace.combine(monotonicity, namespace.getMonotonicity(namespace.getRowType().getFieldNames().get(index)));
        }
        return Util.first(monotonicity, SqlMonotonicity.NOT_MONOTONIC);
    }

    private static SqlMonotonicity combine(@Nullable SqlMonotonicity m0, SqlMonotonicity m1) {
        if (m0 == null) {
            return m1;
        }
        if (m1 == null) {
            return m0;
        }
        if (m0 == m1) {
            return m0;
        }
        if (m0.unstrict() == m1) {
            return m1;
        }
        if (m1.unstrict() == m0) {
            return m0;
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public RelDataType validateImpl(RelDataType targetRowType) {
        switch (this.call.getKind()) {
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                SqlValidatorScope scope = Objects.requireNonNull(this.validator.scopes.get(this.call), () -> "scope for " + this.call);
                for (SqlNode operand : this.call.getOperandList()) {
                    if (!operand.isA(SqlKind.QUERY)) {
                        throw this.validator.newValidationError(operand, Static.RESOURCE.needQueryOp(operand.toString()));
                    }
                    this.validator.validateQuery(operand, scope, targetRowType);
                }
                return this.call.getOperator().deriveType(this.validator, scope, this.call);
            }
        }
        throw new AssertionError((Object)("Not a query: " + (Object)((Object)this.call.getKind())));
    }
}

