/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.util;

import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.hive.druid.org.apache.calcite.util.DateTimeStringUtils;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TimeString
implements Comparable<TimeString> {
    private static final Pattern PATTERN = Pattern.compile("[0-9][0-9]:[0-9][0-9]:[0-9][0-9](\\.[0-9]*[1-9])?");
    final String v;

    private TimeString(String v, boolean ignore) {
        this.v = v;
    }

    public TimeString(String v) {
        this(v, false);
        Preconditions.checkArgument((boolean)PATTERN.matcher(v).matches(), (String)"Invalid time format:", (Object)v);
        Preconditions.checkArgument((this.getHour() >= 0 && this.getHour() < 24 ? 1 : 0) != 0, (String)"Hour out of range:", (int)this.getHour());
        Preconditions.checkArgument((this.getMinute() >= 0 && this.getMinute() < 60 ? 1 : 0) != 0, (String)"Minute out of range:", (int)this.getMinute());
        Preconditions.checkArgument((this.getSecond() >= 0 && this.getSecond() < 60 ? 1 : 0) != 0, (String)"Second out of range:", (int)this.getSecond());
    }

    public TimeString(int h, int m, int s) {
        this(TimeString.hms(h, m, s), false);
    }

    private static String hms(int h, int m, int s) {
        Preconditions.checkArgument((h >= 0 && h < 24 ? 1 : 0) != 0, (String)"Hour out of range:", (int)h);
        Preconditions.checkArgument((m >= 0 && m < 60 ? 1 : 0) != 0, (String)"Minute out of range:", (int)m);
        Preconditions.checkArgument((s >= 0 && s < 60 ? 1 : 0) != 0, (String)"Second out of range:", (int)s);
        StringBuilder b = new StringBuilder();
        DateTimeStringUtils.hms(b, h, m, s);
        return b.toString();
    }

    public TimeString withMillis(int millis) {
        Preconditions.checkArgument(millis >= 0 && millis < 1000);
        return this.withFraction(DateTimeStringUtils.pad(3, millis));
    }

    public TimeString withNanos(int nanos) {
        Preconditions.checkArgument(nanos >= 0 && nanos < 1000000000);
        return this.withFraction(DateTimeStringUtils.pad(9, nanos));
    }

    public TimeString withFraction(String fraction) {
        String v = this.v;
        int i = v.indexOf(46);
        if (i >= 0) {
            v = v.substring(0, i);
        }
        while (fraction.endsWith("0")) {
            fraction = fraction.substring(0, fraction.length() - 1);
        }
        if (fraction.length() > 0) {
            v = v + "." + fraction;
        }
        return new TimeString(v);
    }

    public String toString() {
        return this.v;
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof TimeString && ((TimeString)o).v.equals(this.v);
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    @Override
    public int compareTo(TimeString o) {
        return this.v.compareTo(o.v);
    }

    public static TimeString fromCalendarFields(Calendar calendar) {
        return new TimeString(calendar.get(11), calendar.get(12), calendar.get(13)).withMillis(calendar.get(14));
    }

    public static TimeString fromMillisOfDay(int i) {
        return new TimeString(DateTimeUtils.unixTimeToString((int)i)).withMillis((int)Math.floorMod((long)i, 1000L));
    }

    public TimeString round(int precision) {
        Preconditions.checkArgument(precision >= 0);
        int targetLength = 9 + precision;
        if (this.v.length() <= targetLength) {
            return this;
        }
        String v = this.v.substring(0, targetLength);
        while (v.length() >= 9 && (v.endsWith("0") || v.endsWith("."))) {
            v = v.substring(0, v.length() - 1);
        }
        return new TimeString(v);
    }

    public int getMillisOfDay() {
        int h = Integer.valueOf(this.v.substring(0, 2));
        int m = Integer.valueOf(this.v.substring(3, 5));
        int s = Integer.valueOf(this.v.substring(6, 8));
        int ms = this.getMillisInSecond();
        return (int)((long)h * 3600000L + (long)m * 60000L + (long)s * 1000L + (long)ms);
    }

    private int getMillisInSecond() {
        switch (this.v.length()) {
            case 8: {
                return 0;
            }
            case 10: {
                return Integer.valueOf(this.v.substring(9)) * 100;
            }
            case 11: {
                return Integer.valueOf(this.v.substring(9)) * 10;
            }
        }
        return Integer.valueOf(this.v.substring(9, 12));
    }

    private int getHour() {
        return Integer.parseInt(this.v.substring(0, 2));
    }

    private int getMinute() {
        return Integer.parseInt(this.v.substring(3, 5));
    }

    private int getSecond() {
        return Integer.parseInt(this.v.substring(6, 8));
    }

    public Calendar toCalendar() {
        return Util.calendar(this.getMillisOfDay());
    }

    public String toString(int precision) {
        Preconditions.checkArgument(precision >= 0);
        int p = this.precision();
        if (precision < p) {
            return this.round(precision).toString(precision);
        }
        if (precision > p) {
            String s = this.v;
            if (p == 0) {
                s = s + ".";
            }
            return s + Strings.repeat("0", precision - p);
        }
        return this.v;
    }

    private int precision() {
        return this.v.length() < 9 ? 0 : this.v.length() - 9;
    }
}

