/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.util.javac;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;

public class JavaCompilerArgs {
    List<String> argsList = new ArrayList<String>();
    List<String> fileNameList = new ArrayList<String>();
    ClassLoader classLoader = Objects.requireNonNull(this.getClass().getClassLoader(), () -> "getClassLoader is null for " + this.getClass());

    public void clear() {
        this.fileNameList.clear();
    }

    public void setString(String args) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(args);
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        this.setStringArray(list.toArray(new String[0]));
    }

    public void setStringArray(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-classpath")) {
                if (++i >= args.length) continue;
                this.setClasspath(args[i]);
                continue;
            }
            if (arg.equals("-d")) {
                if (++i >= args.length) continue;
                this.setDestdir(args[i]);
                continue;
            }
            if (arg.equals("-verbose")) {
                this.setVerbose(true);
                continue;
            }
            this.argsList.add(args[i]);
        }
    }

    public String[] getStringArray() {
        this.argsList.addAll(this.fileNameList);
        return this.argsList.toArray(new String[0]);
    }

    public void addFile(String fileName) {
        this.fileNameList.add(fileName);
    }

    public String[] getFileNames() {
        return this.fileNameList.toArray(new String[0]);
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.argsList.add("-verbose");
        }
    }

    public void setDestdir(String destdir) {
        this.argsList.add("-d");
        this.argsList.add(destdir);
    }

    public void setClasspath(String classpath) {
        this.argsList.add("-classpath");
        this.argsList.add(classpath);
    }

    public void setDebugInfo(int i) {
        if (i > 0) {
            this.argsList.add("-g=" + i);
        }
    }

    public void setSource(String source, String fileName) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSetSource() {
        return false;
    }

    public void setFullClassName(String fullClassName) {
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

