/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.Overshadowable;

public class SegmentLoadInfo
implements Overshadowable<SegmentLoadInfo> {
    private final DataSegment segment;
    private final Set<DruidServerMetadata> servers;

    public SegmentLoadInfo(DataSegment segment) {
        Preconditions.checkNotNull(segment, "segment");
        this.segment = segment;
        this.servers = Sets.newConcurrentHashSet();
    }

    public boolean addServer(DruidServerMetadata server) {
        return this.servers.add(server);
    }

    public boolean removeServer(DruidServerMetadata server) {
        return this.servers.remove(server);
    }

    public boolean isEmpty() {
        return this.servers.isEmpty();
    }

    public ImmutableSegmentLoadInfo toImmutableSegmentLoadInfo() {
        return new ImmutableSegmentLoadInfo(this.segment, this.servers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentLoadInfo that = (SegmentLoadInfo)o;
        if (!this.segment.equals(that.segment)) {
            return false;
        }
        return this.servers.equals(that.servers);
    }

    public int hashCode() {
        int result = this.segment.hashCode();
        result = 31 * result + this.servers.hashCode();
        return result;
    }

    public String toString() {
        return "SegmentLoadInfo{segment=" + this.segment + ", servers=" + this.servers + '}';
    }

    @Override
    public boolean overshadows(SegmentLoadInfo other) {
        return this.segment.overshadows(other.segment);
    }

    @Override
    public int getStartRootPartitionId() {
        return this.segment.getStartRootPartitionId();
    }

    @Override
    public int getEndRootPartitionId() {
        return this.segment.getEndRootPartitionId();
    }

    @Override
    public String getVersion() {
        return this.segment.getVersion();
    }

    @Override
    public short getMinorVersion() {
        return this.segment.getMinorVersion();
    }

    @Override
    public short getAtomicUpdateGroupSize() {
        return this.segment.getAtomicUpdateGroupSize();
    }
}

