/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

import com.google.inject.Inject;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheStats;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.AbstractMonitor;

public class CacheMonitor
extends AbstractMonitor {
    volatile Cache cache;
    private final CachePopulatorStats cachePopulatorStats;
    private volatile CacheStats prevCacheStats = null;
    private volatile CachePopulatorStats.Snapshot prevCachePopulatorStats = null;

    @Inject
    public CacheMonitor(CachePopulatorStats cachePopulatorStats) {
        this.cachePopulatorStats = cachePopulatorStats;
    }

    @Inject(optional=true)
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        if (this.cache != null) {
            CacheStats currCacheStats = this.cache.getStats();
            CacheStats deltaCacheStats = currCacheStats.delta(this.prevCacheStats);
            CachePopulatorStats.Snapshot currCachePopulatorStats = this.cachePopulatorStats.snapshot();
            CachePopulatorStats.Snapshot deltaCachePopulatorStats = currCachePopulatorStats.delta(this.prevCachePopulatorStats);
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            this.emitStats(emitter, "query/cache/delta", deltaCachePopulatorStats, deltaCacheStats, builder);
            this.emitStats(emitter, "query/cache/total", currCachePopulatorStats, currCacheStats, builder);
            this.prevCachePopulatorStats = currCachePopulatorStats;
            this.prevCacheStats = currCacheStats;
            this.cache.doMonitor(emitter);
        }
        return true;
    }

    private void emitStats(ServiceEmitter emitter, String metricPrefix, CachePopulatorStats.Snapshot cachePopulatorStats, CacheStats cacheStats, ServiceMetricEvent.Builder builder) {
        if (this.cache != null) {
            emitter.emit(builder.build(StringUtils.format("%s/numEntries", metricPrefix), cacheStats.getNumEntries()));
            emitter.emit(builder.build(StringUtils.format("%s/sizeBytes", metricPrefix), cacheStats.getSizeInBytes()));
            emitter.emit(builder.build(StringUtils.format("%s/hits", metricPrefix), cacheStats.getNumHits()));
            emitter.emit(builder.build(StringUtils.format("%s/misses", metricPrefix), cacheStats.getNumMisses()));
            emitter.emit(builder.build(StringUtils.format("%s/evictions", metricPrefix), cacheStats.getNumEvictions()));
            emitter.emit(builder.build(StringUtils.format("%s/hitRate", metricPrefix), cacheStats.hitRate()));
            emitter.emit(builder.build(StringUtils.format("%s/averageBytes", metricPrefix), cacheStats.averageBytes()));
            emitter.emit(builder.build(StringUtils.format("%s/timeouts", metricPrefix), cacheStats.getNumTimeouts()));
            emitter.emit(builder.build(StringUtils.format("%s/errors", metricPrefix), cacheStats.getNumErrors()));
            emitter.emit(builder.build(StringUtils.format("%s/put/ok", metricPrefix), cachePopulatorStats.getNumOk()));
            emitter.emit(builder.build(StringUtils.format("%s/put/error", metricPrefix), cachePopulatorStats.getNumError()));
            emitter.emit(builder.build(StringUtils.format("%s/put/oversized", metricPrefix), cachePopulatorStats.getNumOversized()));
        }
    }
}

