/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

import com.google.inject.name.Named;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheProvider;
import org.apache.hive.druid.org.apache.druid.client.cache.HybridCache;
import org.apache.hive.druid.org.apache.druid.client.cache.HybridCacheConfig;

public class HybridCacheProvider
extends HybridCacheConfig
implements CacheProvider {
    final CacheProvider level1;
    final CacheProvider level2;

    @JsonCreator
    public HybridCacheProvider(@JacksonInject @Named(value="l1") CacheProvider level1, @JacksonInject @Named(value="l2") CacheProvider level2) {
        this.level1 = Preconditions.checkNotNull(level1, "l1 cache not specified for hybrid cache");
        this.level2 = Preconditions.checkNotNull(level2, "l2 cache not specified for hybrid cache");
        if (!this.getUseL2() && !this.getPopulateL2()) {
            throw new IllegalStateException("Doesn't make sense to use Hybrid cache with both use and populate disabled for L2, use just L1 cache in this case");
        }
    }

    public Cache get() {
        return new HybridCache(this, (Cache)this.level1.get(), (Cache)this.level2.get());
    }
}

