/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.indexing;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.JodaUtils;
import org.apache.hive.druid.org.apache.druid.segment.SegmentUtils;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class ClientCompactionIntervalSpec {
    private static final String TYPE = "interval";
    private final Interval interval;
    @Nullable
    private final String sha256OfSortedSegmentIds;

    public static ClientCompactionIntervalSpec fromSegments(List<DataSegment> segments) {
        return new ClientCompactionIntervalSpec(JodaUtils.umbrellaInterval(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList())), SegmentUtils.hashIds(segments));
    }

    @JsonCreator
    public ClientCompactionIntervalSpec(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="sha256OfSortedSegmentIds") @Nullable String sha256OfSortedSegmentIds) {
        if (interval != null && interval.toDurationMillis() == 0L) {
            throw new IAE("Interval[%s] is empty, must specify a nonempty interval", interval);
        }
        this.interval = interval;
        this.sha256OfSortedSegmentIds = sha256OfSortedSegmentIds;
    }

    @JsonProperty
    public String getType() {
        return TYPE;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    @JsonProperty
    public String getSha256OfSortedSegmentIds() {
        return this.sha256OfSortedSegmentIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactionIntervalSpec that = (ClientCompactionIntervalSpec)o;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.sha256OfSortedSegmentIds, that.sha256OfSortedSegmentIds);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.sha256OfSortedSegmentIds);
    }

    public String toString() {
        return "ClientCompactionIntervalSpec{interval=" + this.interval + ", sha256OfSortedSegmentIds='" + this.sha256OfSortedSegmentIds + '\'' + '}';
    }
}

