/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections;

import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.org.apache.druid.collections.NonBlockingPool;
import org.apache.hive.druid.org.apache.druid.collections.ResourceHolder;
import org.apache.hive.druid.org.apache.druid.java.util.common.Cleaners;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;

public class StupidPool<T>
implements NonBlockingPool<T> {
    private static final Logger log = new Logger(StupidPool.class);
    @VisibleForTesting
    final Queue<ObjectResourceHolder> objects = new ConcurrentLinkedQueue<ObjectResourceHolder>();
    @VisibleForTesting
    final AtomicLong poolSize = new AtomicLong(0L);
    private final String name;
    private final Supplier<T> generator;
    private final AtomicLong leakedObjectsCounter = new AtomicLong(0L);
    private final int objectsCacheMaxCount;

    public StupidPool(String name, Supplier<T> generator) {
        this(name, generator, 0, Integer.MAX_VALUE);
    }

    public StupidPool(String name, Supplier<T> generator, int initCount, int objectsCacheMaxCount) {
        Preconditions.checkArgument(initCount <= objectsCacheMaxCount, "initCount[%s] must be less/equal to objectsCacheMaxCount[%s]", initCount, objectsCacheMaxCount);
        this.name = name;
        this.generator = generator;
        this.objectsCacheMaxCount = objectsCacheMaxCount;
        for (int i = 0; i < initCount; ++i) {
            this.objects.add(this.makeObjectWithHandler());
            this.poolSize.incrementAndGet();
        }
    }

    public String toString() {
        return "StupidPool{name=" + this.name + ", objectsCacheMaxCount=" + this.objectsCacheMaxCount + ", poolSize=" + this.poolSize() + "}";
    }

    @Override
    public ResourceHolder<T> take() {
        ObjectResourceHolder resourceHolder = this.objects.poll();
        if (resourceHolder == null) {
            return this.makeObjectWithHandler();
        }
        this.poolSize.decrementAndGet();
        return resourceHolder;
    }

    private ObjectResourceHolder makeObjectWithHandler() {
        T object = this.generator.get();
        ObjectId objectId = new ObjectId();
        ObjectLeakNotifier notifier = new ObjectLeakNotifier(this);
        return new ObjectResourceHolder(object, objectId, Cleaners.register(objectId, notifier), notifier);
    }

    @VisibleForTesting
    long poolSize() {
        return this.poolSize.get();
    }

    @VisibleForTesting
    long leakedObjectsCount() {
        return this.leakedObjectsCounter.get();
    }

    private void tryReturnToPool(T object, ObjectId objectId, Cleaners.Cleanable cleanable, ObjectLeakNotifier notifier) {
        long currentPoolSize;
        do {
            if ((currentPoolSize = this.poolSize.get()) < (long)this.objectsCacheMaxCount) continue;
            notifier.disable();
            cleanable.clean();
            log.debug("cache num entries is exceeding in [%s], objectId [%s]", this, objectId);
            return;
        } while (!this.poolSize.compareAndSet(currentPoolSize, currentPoolSize + 1L));
        if (!this.objects.offer(new ObjectResourceHolder(object, objectId, cleanable, notifier))) {
            this.impossibleOffsetFailed(object, objectId, cleanable, notifier);
        }
    }

    private void impossibleOffsetFailed(T object, ObjectId objectId, Cleaners.Cleanable cleanable, ObjectLeakNotifier notifier) {
        this.poolSize.decrementAndGet();
        notifier.disable();
        cleanable.clean();
        log.error(new ISE("Queue offer failed", new Object[0]), "Could not offer object [%s] back into the queue, objectId [%s]", object, objectId);
    }

    private static class ObjectId {
        private ObjectId() {
        }
    }

    private static class ObjectLeakNotifier
    implements Runnable {
        final WeakReference<StupidPool<?>> poolReference;
        final AtomicLong leakedObjectsCounter;
        final AtomicBoolean disabled = new AtomicBoolean(false);

        ObjectLeakNotifier(StupidPool<?> pool) {
            this.poolReference = new WeakReference(pool);
            this.leakedObjectsCounter = ((StupidPool)pool).leakedObjectsCounter;
        }

        @Override
        public void run() {
            try {
                if (!this.disabled.getAndSet(true)) {
                    this.leakedObjectsCounter.incrementAndGet();
                    log.warn("Not closed! Object leaked from %s. Allowing gc to prevent leak.", this.poolReference.get());
                }
            }
            catch (Exception e) {
                try {
                    log.error(e, "Exception in ObjectLeakNotifier.run()", new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void disable() {
            this.disabled.set(true);
        }
    }

    private class ObjectResourceHolder
    implements ResourceHolder<T> {
        private final AtomicReference<T> objectRef;
        private ObjectId objectId;
        private Cleaners.Cleanable cleanable;
        private ObjectLeakNotifier notifier;

        ObjectResourceHolder(T object, ObjectId objectId, Cleaners.Cleanable cleanable, ObjectLeakNotifier notifier) {
            this.objectRef = new AtomicReference(object);
            this.objectId = objectId;
            this.cleanable = cleanable;
            this.notifier = notifier;
        }

        @Override
        public T get() {
            Object object = this.objectRef.get();
            if (object == null) {
                throw new ISE("Already Closed!", new Object[0]);
            }
            return object;
        }

        @Override
        public void close() {
            Object object = this.objectRef.get();
            if (object != null && this.objectRef.compareAndSet(object, null)) {
                try {
                    StupidPool.this.tryReturnToPool(object, this.objectId, this.cleanable, this.notifier);
                }
                finally {
                    this.objectId = null;
                    this.cleanable = null;
                    this.notifier = null;
                }
            }
        }
    }
}

