/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.bitmap;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedImmutableBitSetBitmap;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;

public class WrappedBitSetBitmap
extends WrappedImmutableBitSetBitmap
implements MutableBitmap {
    public WrappedBitSetBitmap() {
    }

    public WrappedBitSetBitmap(BitSet bitSet) {
        super(bitSet);
    }

    public WrappedBitSetBitmap(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    protected BitSet cloneBitSet() {
        return (BitSet)this.bitmap.clone();
    }

    @Override
    public void clear() {
        this.bitmap.clear();
    }

    @Override
    public void or(MutableBitmap mutableBitmap) {
        if (!(mutableBitmap instanceof WrappedBitSetBitmap)) {
            throw new IAE("Unknown class type: %s  expected %s", mutableBitmap.getClass().getName(), WrappedBitSetBitmap.class.getName());
        }
        WrappedBitSetBitmap bitSet = (WrappedBitSetBitmap)mutableBitmap;
        this.bitmap.or(bitSet.bitmap);
    }

    public void and(MutableBitmap mutableBitmap) {
        if (!(mutableBitmap instanceof WrappedBitSetBitmap)) {
            throw new IAE("Unknown class type: %s  expected %s", mutableBitmap.getClass().getName(), WrappedBitSetBitmap.class.getName());
        }
        WrappedBitSetBitmap bitSet = (WrappedBitSetBitmap)mutableBitmap;
        this.bitmap.and(bitSet.bitmap);
    }

    public void andNot(MutableBitmap mutableBitmap) {
        if (!(mutableBitmap instanceof WrappedBitSetBitmap)) {
            throw new IAE("Unknown class type: %s  expected %s", mutableBitmap.getClass().getName(), WrappedBitSetBitmap.class.getName());
        }
        WrappedBitSetBitmap bitSet = (WrappedBitSetBitmap)mutableBitmap;
        this.bitmap.andNot(bitSet.bitmap);
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.size() / 8;
    }

    @Override
    public void add(int entry) {
        this.bitmap.set(entry);
    }

    @Override
    public void remove(int entry) {
        this.bitmap.clear(entry);
    }

    public void serialize(ByteBuffer buffer) {
        buffer.put(this.bitmap.toByteArray());
    }
}

