/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntity;
import org.apache.hive.druid.org.apache.druid.data.input.impl.RetryingInputStream;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.hive.druid.org.apache.druid.utils.CompressionUtils;

public abstract class RetryingInputEntity
implements InputEntity {
    @Override
    public InputStream open() throws IOException {
        RetryingInputStream<RetryingInputEntity> retryingInputStream = new RetryingInputStream<RetryingInputEntity>(this, new RetryingInputEntityOpenFunction(), this.getRetryCondition(), 10);
        return CompressionUtils.decompress(retryingInputStream, this.getPath());
    }

    protected InputStream readFromStart() throws IOException {
        return this.readFrom(0L);
    }

    protected abstract InputStream readFrom(long var1) throws IOException;

    protected abstract String getPath();

    private static class RetryingInputEntityOpenFunction
    implements ObjectOpenFunction<RetryingInputEntity> {
        private RetryingInputEntityOpenFunction() {
        }

        @Override
        public InputStream open(RetryingInputEntity object) throws IOException {
            return object.readFromStart();
        }

        @Override
        public InputStream open(RetryingInputEntity object, long start) throws IOException {
            return object.readFrom(start);
        }
    }
}

