/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.data.input.InputFormat;
import org.apache.hive.druid.org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CSVParser;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.Parser;

public class CSVParseSpec
extends ParseSpec {
    private final String listDelimiter;
    private final List<String> columns;
    private final boolean hasHeaderRow;
    private final int skipHeaderRows;

    @JsonCreator
    public CSVParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="hasHeaderRow") boolean hasHeaderRow, @JsonProperty(value="skipHeaderRows") int skipHeaderRows) {
        super(timestampSpec, dimensionsSpec);
        this.listDelimiter = listDelimiter;
        this.columns = columns;
        this.hasHeaderRow = hasHeaderRow;
        this.skipHeaderRows = skipHeaderRows;
        if (columns != null) {
            for (String column : columns) {
                Preconditions.checkArgument(!column.contains(","), "Column[%s] has a comma, it cannot", column);
            }
        } else {
            Preconditions.checkArgument(hasHeaderRow, "If columns field is not set, the first row of your data must have your header and hasHeaderRow must be set to true.");
        }
    }

    @JsonProperty
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public boolean isHasHeaderRow() {
        return this.hasHeaderRow;
    }

    @JsonProperty(value="skipHeaderRows")
    public int getSkipHeaderRows() {
        return this.skipHeaderRows;
    }

    @Override
    public Parser<String, Object> makeParser() {
        return new CSVParser(this.listDelimiter, this.columns, this.hasHeaderRow, this.skipHeaderRows);
    }

    @Override
    public InputFormat toInputFormat() {
        return new CsvInputFormat(this.columns, this.listDelimiter, null, this.hasHeaderRow, this.skipHeaderRows);
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new CSVParseSpec(spec, this.getDimensionsSpec(), this.listDelimiter, this.columns, this.hasHeaderRow, this.skipHeaderRows);
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new CSVParseSpec(this.getTimestampSpec(), spec, this.listDelimiter, this.columns, this.hasHeaderRow, this.skipHeaderRows);
    }
}

