/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.org.apache.druid.data.input.AbstractInputSource;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntity;
import org.apache.hive.druid.org.apache.druid.data.input.InputFormat;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.InputSourceReader;
import org.apache.hive.druid.org.apache.druid.data.input.InputSplit;
import org.apache.hive.druid.org.apache.druid.data.input.SplitHintSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.hive.druid.org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.hive.druid.org.apache.druid.utils.CollectionUtils;

public abstract class CloudObjectInputSource<T extends InputEntity>
extends AbstractInputSource
implements SplittableInputSource<CloudObjectLocation> {
    private final List<URI> uris;
    private final List<URI> prefixes;
    private final List<CloudObjectLocation> objects;

    public CloudObjectInputSource(String scheme, @Nullable List<URI> uris, @Nullable List<URI> prefixes, @Nullable List<CloudObjectLocation> objects) {
        this.uris = uris;
        this.prefixes = prefixes;
        this.objects = objects;
        if (!CollectionUtils.isNullOrEmpty(objects)) {
            this.throwIfIllegalArgs(!CollectionUtils.isNullOrEmpty(uris) || !CollectionUtils.isNullOrEmpty(prefixes));
        } else if (!CollectionUtils.isNullOrEmpty(uris)) {
            this.throwIfIllegalArgs(!CollectionUtils.isNullOrEmpty(prefixes));
            uris.forEach(uri -> CloudObjectLocation.validateUriScheme(scheme, uri));
        } else if (!CollectionUtils.isNullOrEmpty(prefixes)) {
            prefixes.forEach(uri -> CloudObjectLocation.validateUriScheme(scheme, uri));
        } else {
            this.throwIfIllegalArgs(true);
        }
    }

    @JsonProperty
    public List<URI> getUris() {
        return this.uris;
    }

    @JsonProperty
    public List<URI> getPrefixes() {
        return this.prefixes;
    }

    @Nullable
    @JsonProperty
    public List<CloudObjectLocation> getObjects() {
        return this.objects;
    }

    protected abstract T createEntity(InputSplit<CloudObjectLocation> var1);

    protected abstract Stream<InputSplit<CloudObjectLocation>> getPrefixesSplitStream();

    @Override
    public Stream<InputSplit<CloudObjectLocation>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        if (!CollectionUtils.isNullOrEmpty(this.objects)) {
            return this.objects.stream().map(InputSplit::new);
        }
        if (!CollectionUtils.isNullOrEmpty(this.uris)) {
            return this.uris.stream().map(CloudObjectLocation::new).map(InputSplit::new);
        }
        return this.getPrefixesSplitStream();
    }

    @Override
    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        if (!CollectionUtils.isNullOrEmpty(this.objects)) {
            return this.objects.size();
        }
        if (!CollectionUtils.isNullOrEmpty(this.uris)) {
            return this.uris.size();
        }
        return Ints.checkedCast(this.getPrefixesSplitStream().count());
    }

    @Override
    public boolean needsFormat() {
        return true;
    }

    @Override
    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, @Nullable File temporaryDirectory) {
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, this.createSplits(inputFormat, null).map(this::createEntity), temporaryDirectory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudObjectInputSource that = (CloudObjectInputSource)o;
        return Objects.equals(this.uris, that.uris) && Objects.equals(this.prefixes, that.prefixes) && Objects.equals(this.objects, that.objects);
    }

    public int hashCode() {
        return Objects.hash(this.uris, this.prefixes, this.objects);
    }

    private void throwIfIllegalArgs(boolean clause) throws IllegalArgumentException {
        if (clause) {
            throw new IllegalArgumentException("exactly one of either uris or prefixes or objects must be specified");
        }
    }
}

