/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntity;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntityReader;
import org.apache.hive.druid.org.apache.druid.data.input.InputFormat;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.InputSourceReader;
import org.apache.hive.druid.org.apache.druid.java.util.common.CloseableIterators;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;

public class InputEntityIteratingReader
implements InputSourceReader {
    private final InputRowSchema inputRowSchema;
    private final InputFormat inputFormat;
    private final CloseableIterator<InputEntity> sourceIterator;
    private final File temporaryDirectory;

    public InputEntityIteratingReader(InputRowSchema inputRowSchema, InputFormat inputFormat, Stream<InputEntity> sourceStream, File temporaryDirectory) {
        this(inputRowSchema, inputFormat, CloseableIterators.withEmptyBaggage(sourceStream.iterator()), temporaryDirectory);
    }

    public InputEntityIteratingReader(InputRowSchema inputRowSchema, InputFormat inputFormat, CloseableIterator<InputEntity> sourceIterator, File temporaryDirectory) {
        this.inputRowSchema = inputRowSchema;
        this.inputFormat = inputFormat;
        this.sourceIterator = sourceIterator;
        this.temporaryDirectory = temporaryDirectory;
    }

    @Override
    public CloseableIterator<InputRow> read() {
        return this.createIterator(entity -> {
            try {
                InputEntityReader reader = this.inputFormat.createReader(this.inputRowSchema, (InputEntity)entity, this.temporaryDirectory);
                return reader.read();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CloseableIterator<InputRowListPlusRawValues> sample() {
        return this.createIterator(entity -> {
            try {
                InputEntityReader reader = this.inputFormat.createReader(this.inputRowSchema, (InputEntity)entity, this.temporaryDirectory);
                return reader.sample();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <R> CloseableIterator<R> createIterator(Function<InputEntity, CloseableIterator<R>> rowPopulator) {
        return this.sourceIterator.flatMap(rowPopulator);
    }
}

