/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntity;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.TextReader;
import org.apache.hive.druid.org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.org.apache.druid.java.util.common.collect.Utils;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParserUtils;

public class RegexReader
extends TextReader {
    private final String pattern;
    private final Pattern compiled;
    private final Function<String, Object> multiValueFunction;
    private List<String> columns;

    RegexReader(InputRowSchema inputRowSchema, InputEntity source, String pattern, @Nullable String listDelimiter, @Nullable List<String> columns) {
        super(inputRowSchema, source);
        this.pattern = pattern;
        this.compiled = Pattern.compile(pattern);
        String finalListDelimeter = listDelimiter == null ? "\u0001" : listDelimiter;
        this.multiValueFunction = ParserUtils.getMultiValueFunction(finalListDelimeter, Splitter.on(finalListDelimeter));
        this.columns = columns;
    }

    @Override
    public List<InputRow> parseInputRows(String intermediateRow) throws ParseException {
        return Collections.singletonList(MapInputRowParser.parse(this.getInputRowSchema(), this.parseLine(intermediateRow)));
    }

    @Override
    protected Map<String, Object> toMap(String intermediateRow) {
        return this.parseLine(intermediateRow);
    }

    private Map<String, Object> parseLine(String line) {
        try {
            Matcher matcher = this.compiled.matcher(line);
            if (!matcher.matches()) {
                throw new ParseException("Incorrect Regex: %s . No match found.", this.pattern);
            }
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                values.add(matcher.group(i));
            }
            if (this.columns == null) {
                this.columns = ParserUtils.generateFieldNames(matcher.groupCount());
            }
            return Utils.zipMapPartial(this.columns, Iterables.transform(values, this.multiValueFunction));
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse row [%s]", line);
        }
    }

    @Override
    public int getNumHeaderLinesToSkip() {
        return 0;
    }

    @Override
    public boolean needsToProcessHeaderLine() {
        return false;
    }

    @Override
    public void processHeaderLine(String line) {
    }
}

