/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.FetchedFile;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;

public class CacheManager<T> {
    private static final Logger LOG = new Logger(CacheManager.class);
    private final long maxCacheCapacityBytes;
    private final List<FetchedFile<T>> files = new ArrayList<FetchedFile<T>>();
    private long totalCachedBytes;

    public CacheManager(long maxCacheCapacityBytes) {
        this.maxCacheCapacityBytes = maxCacheCapacityBytes;
    }

    public boolean isEnabled() {
        return this.maxCacheCapacityBytes > 0L;
    }

    public boolean cacheable() {
        return this.totalCachedBytes < this.maxCacheCapacityBytes;
    }

    FetchedFile<T> cache(FetchedFile<T> fetchedFile) {
        if (!this.cacheable()) {
            throw new ISE("Cache space is full. totalCachedBytes[%d], maxCacheCapacityBytes[%d]", this.totalCachedBytes, this.maxCacheCapacityBytes);
        }
        FetchedFile<T> cachedFile = fetchedFile.cache();
        this.files.add(cachedFile);
        this.totalCachedBytes += cachedFile.length();
        LOG.info("Object[%s] is cached. Current cached bytes is [%d]", cachedFile.getObject(), this.totalCachedBytes);
        return cachedFile;
    }

    List<FetchedFile<T>> getFiles() {
        return this.files;
    }

    @VisibleForTesting
    long getTotalCachedBytes() {
        return this.totalCachedBytes;
    }

    public long getMaxCacheCapacityBytes() {
        return this.maxCacheCapacityBytes;
    }
}

