/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.hive.druid.com.google.common.base.Predicate;

public class ConditionalMultibind<T> {
    private final Properties properties;
    private final Multibinder<T> multibinder;

    public static <T> ConditionalMultibind<T> create(Properties properties, Binder binder, Class<T> type) {
        return new ConditionalMultibind<T>(properties, Multibinder.newSetBinder((Binder)binder, type));
    }

    public static <T> ConditionalMultibind<T> create(Properties properties, Binder binder, Class<T> type, Class<? extends Annotation> annotationType) {
        return new ConditionalMultibind<T>(properties, Multibinder.newSetBinder((Binder)binder, type, annotationType));
    }

    public static <T> ConditionalMultibind<T> create(Properties properties, Binder binder, TypeLiteral<T> type) {
        return new ConditionalMultibind<T>(properties, Multibinder.newSetBinder((Binder)binder, type));
    }

    public static <T> ConditionalMultibind<T> create(Properties properties, Binder binder, TypeLiteral<T> type, Class<? extends Annotation> annotationType) {
        return new ConditionalMultibind<T>(properties, Multibinder.newSetBinder((Binder)binder, type, annotationType));
    }

    public ConditionalMultibind(Properties properties, Multibinder<T> multibinder) {
        this.properties = properties;
        this.multibinder = multibinder;
    }

    public ConditionalMultibind<T> addBinding(Class<? extends T> target) {
        this.multibinder.addBinding().to(target);
        return this;
    }

    public ConditionalMultibind<T> addBinding(T target) {
        this.multibinder.addBinding().toInstance(target);
        return this;
    }

    public ConditionalMultibind<T> addBinding(TypeLiteral<T> target) {
        this.multibinder.addBinding().to(target);
        return this;
    }

    public ConditionalMultibind<T> addConditionBinding(String property, Predicate<String> condition, Class<? extends T> target) {
        if (this.matchCondition(property, condition)) {
            this.multibinder.addBinding().to(target);
        }
        return this;
    }

    public ConditionalMultibind<T> addConditionBinding(String property, Predicate<String> condition, T target) {
        if (this.matchCondition(property, condition)) {
            this.multibinder.addBinding().toInstance(target);
        }
        return this;
    }

    public ConditionalMultibind<T> addConditionBinding(String property, Predicate<String> condition, TypeLiteral<T> target) {
        if (this.matchCondition(property, condition)) {
            this.multibinder.addBinding().to(target);
        }
        return this;
    }

    public boolean matchCondition(String property, Predicate<String> condition) {
        String value = this.properties.getProperty(property);
        if (value == null) {
            return false;
        }
        return condition.apply(value);
    }
}

