/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.indexing.worker.config;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.apache.hive.druid.org.apache.druid.utils.JvmUtils;
import org.joda.time.Period;

public class WorkerConfig {
    public static final String DEFAULT_CATEGORY = "_default_worker_category";
    @JsonProperty
    private String ip = DruidNode.getDefaultHost();
    @JsonProperty
    private String version = "0";
    @JsonProperty
    @Min(value=1L)
    private int capacity = Math.max(1, JvmUtils.getRuntimeInfo().getAvailableProcessors() - 1);
    @JsonProperty
    @NotNull
    private String category = "_default_worker_category";
    private long intermediaryPartitionDiscoveryPeriodSec = 60L;
    @JsonProperty
    private long intermediaryPartitionCleanupPeriodSec = 300L;
    @JsonProperty
    private Period intermediaryPartitionTimeout = new Period((Object)"P1D");
    @JsonProperty
    private final long globalIngestionHeapLimitBytes = Runtime.getRuntime().maxMemory() / 6L;
    @JsonProperty
    private final int numConcurrentMerges = Math.max(1, this.capacity / 2);

    public String getIp() {
        return this.ip;
    }

    public String getVersion() {
        return this.version;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public String getCategory() {
        return this.category;
    }

    public long getIntermediaryPartitionDiscoveryPeriodSec() {
        return this.intermediaryPartitionDiscoveryPeriodSec;
    }

    public long getIntermediaryPartitionCleanupPeriodSec() {
        return this.intermediaryPartitionCleanupPeriodSec;
    }

    public Period getIntermediaryPartitionTimeout() {
        return this.intermediaryPartitionTimeout;
    }

    public long getGlobalIngestionHeapLimitBytes() {
        return this.globalIngestionHeapLimitBytes;
    }

    public int getNumConcurrentMerges() {
        return this.numConcurrentMerges;
    }
}

