/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.guava;

import java.util.Iterator;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.DroppingIterator;

public class FunctionalIterator<T>
implements Iterator<T> {
    private final Iterator<T> delegate;

    public static <T> FunctionalIterator<T> create(Iterator<T> delegate) {
        return new FunctionalIterator<T>(delegate);
    }

    public FunctionalIterator(Iterator<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        return this.delegate.next();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    public <RetType> FunctionalIterator<RetType> transform(Function<T, RetType> fn) {
        return new FunctionalIterator<RetType>(Iterators.transform(this.delegate, fn));
    }

    public <RetType> FunctionalIterator<RetType> transformCat(Function<T, Iterator<RetType>> fn) {
        return new FunctionalIterator<RetType>(Iterators.concat(Iterators.transform(this.delegate, fn)));
    }

    public <RetType> FunctionalIterator<RetType> keep(Function<T, RetType> fn) {
        return new FunctionalIterator<RetType>(Iterators.filter(Iterators.transform(this.delegate, fn), Predicates.notNull()));
    }

    public FunctionalIterator<T> filter(Predicate<T> pred) {
        return new FunctionalIterator<T>(Iterators.filter(this.delegate, pred));
    }

    public FunctionalIterator<T> drop(int numToDrop) {
        return new FunctionalIterator<T>(new DroppingIterator<T>(this.delegate, numToDrop));
    }
}

