/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.metrics;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;

class AllocationMetricCollector {
    private static final Logger log = new Logger(AllocationMetricCollector.class);
    private static final int NO_DATA = -1;
    private final Method getThreadAllocatedBytes;
    private final ThreadMXBean threadMXBean;
    private Long2LongMap previousResults;

    AllocationMetricCollector(Method method, ThreadMXBean threadMXBean) {
        this.getThreadAllocatedBytes = method;
        this.threadMXBean = threadMXBean;
        this.previousResults = new Long2LongOpenHashMap();
        this.previousResults.defaultReturnValue(-1L);
    }

    long calculateDelta() {
        try {
            long[] allThreadIds = this.threadMXBean.getAllThreadIds();
            long[] bytes = (long[])this.getThreadAllocatedBytes.invoke((Object)this.threadMXBean, new Object[]{allThreadIds});
            long sum = 0L;
            Long2LongOpenHashMap newResults = new Long2LongOpenHashMap();
            newResults.defaultReturnValue(-1L);
            for (int i = 0; i < allThreadIds.length; ++i) {
                long threadId = allThreadIds[i];
                long previous = this.previousResults.get(threadId);
                long current = bytes[i];
                newResults.put(threadId, current);
                if (previous == -1L || previous > current) {
                    sum += current;
                    continue;
                }
                sum += current - previous;
            }
            this.previousResults = newResults;
            return sum;
        }
        catch (ReflectiveOperationException e) {
            log.error(e, "Cannot calculate delta", new Object[0]);
            return 0L;
        }
    }
}

