/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.RE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.math.expr.ApplyFunction;
import org.apache.hive.druid.org.apache.druid.math.expr.ApplyFunctionExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinAndExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinDivExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinEqExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinGeqExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinGtExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinLeqExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinLtExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinMinusExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinModuloExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinMulExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinNeqExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinOrExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinPlusExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinPowExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.DoubleArrayExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.DoubleExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.math.expr.Function;
import org.apache.hive.druid.org.apache.druid.math.expr.FunctionExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.IdentifierExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.LambdaExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.LongArrayExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.LongExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.Parser;
import org.apache.hive.druid.org.apache.druid.math.expr.StringArrayExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.StringExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.UnaryMinusExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.UnaryNotExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.antlr.ExprBaseListener;
import org.apache.hive.druid.org.apache.druid.math.expr.antlr.ExprParser;

public class ExprListenerImpl
extends ExprBaseListener {
    private final Map<ParseTree, Object> nodes;
    private final ExprMacroTable macroTable;
    private final ParseTree rootNodeKey;
    private final Set<String> lambdaIdentifiers;
    private final Set<String> uniqueIdentifiers;
    private int uniqueCounter = 0;

    ExprListenerImpl(ParseTree rootNodeKey, ExprMacroTable macroTable) {
        this.rootNodeKey = rootNodeKey;
        this.macroTable = macroTable;
        this.nodes = new HashMap<ParseTree, Object>();
        this.lambdaIdentifiers = new HashSet<String>();
        this.uniqueIdentifiers = new HashSet<String>();
    }

    Expr getAST() {
        return (Expr)this.nodes.get(this.rootNodeKey);
    }

    @Override
    public void exitUnaryOpExpr(ExprParser.UnaryOpExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(0)).getSymbol().getType();
        switch (opCode) {
            case 14: {
                this.nodes.put(ctx, new UnaryMinusExpr((Expr)this.nodes.get(ctx.getChild(1))));
                break;
            }
            case 15: {
                this.nodes.put(ctx, new UnaryNotExpr((Expr)this.nodes.get(ctx.getChild(1))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized unary operator " + ctx.getChild(0).getText());
            }
        }
    }

    @Override
    public void exitApplyFunctionExpr(ExprParser.ApplyFunctionExprContext ctx) {
        String fnName = ctx.getChild(0).getText();
        ApplyFunction function = Parser.getApplyFunction(fnName);
        if (function == null) {
            throw new RE("function '%s' is not defined.", fnName);
        }
        this.nodes.put(ctx, new ApplyFunctionExpr(function, fnName, (LambdaExpr)this.nodes.get(ctx.lambda()), (List)this.nodes.get(ctx.fnArgs())));
    }

    @Override
    public void exitDoubleExpr(ExprParser.DoubleExprContext ctx) {
        this.nodes.put(ctx, new DoubleExpr(Double.parseDouble(ctx.getText())));
    }

    @Override
    public void exitDoubleArray(ExprParser.DoubleArrayContext ctx) {
        Double[] values = new Double[ctx.DOUBLE().size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble(ctx.DOUBLE(i).getText());
        }
        this.nodes.put(ctx, new DoubleArrayExpr(values));
    }

    @Override
    public void exitAddSubExpr(ExprParser.AddSubExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 20: {
                this.nodes.put(ctx, new BinPlusExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 14: {
                this.nodes.put(ctx, new BinMinusExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitLongExpr(ExprParser.LongExprContext ctx) {
        this.nodes.put(ctx, new LongExpr(Long.parseLong(ctx.getText())));
    }

    @Override
    public void exitLogicalAndOrExpr(ExprParser.LogicalAndOrExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 27: {
                this.nodes.put(ctx, new BinAndExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 28: {
                this.nodes.put(ctx, new BinOrExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitLongArray(ExprParser.LongArrayContext ctx) {
        Long[] values = new Long[ctx.LONG().size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Long.parseLong(ctx.LONG(i).getText());
        }
        this.nodes.put(ctx, new LongArrayExpr(values));
    }

    @Override
    public void exitNestedExpr(ExprParser.NestedExprContext ctx) {
        this.nodes.put(ctx, this.nodes.get(ctx.getChild(1)));
    }

    @Override
    public void exitString(ExprParser.StringContext ctx) {
        this.nodes.put(ctx, new StringExpr(ExprListenerImpl.escapeStringLiteral(ctx.getText())));
    }

    @Override
    public void exitLogicalOpExpr(ExprParser.LogicalOpExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 21: {
                this.nodes.put(ctx, new BinLtExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 22: {
                this.nodes.put(ctx, new BinLeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 23: {
                this.nodes.put(ctx, new BinGtExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 24: {
                this.nodes.put(ctx, new BinGeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 25: {
                this.nodes.put(ctx, new BinEqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 26: {
                this.nodes.put(ctx, new BinNeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitMulDivModuloExpr(ExprParser.MulDivModuloExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 17: {
                this.nodes.put(ctx, new BinMulExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 18: {
                this.nodes.put(ctx, new BinDivExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 19: {
                this.nodes.put(ctx, new BinModuloExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitPowOpExpr(ExprParser.PowOpExprContext ctx) {
        this.nodes.put(ctx, new BinPowExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
    }

    @Override
    public void exitFunctionExpr(ExprParser.FunctionExprContext ctx) {
        List args;
        String fnName = ctx.getChild(0).getText();
        Expr expr = this.macroTable.get(fnName, args = ctx.getChildCount() > 3 ? (List)this.nodes.get(ctx.getChild(2)) : Collections.emptyList());
        if (expr == null) {
            Function function = Parser.getFunction(fnName);
            if (function == null) {
                throw new RE("function '%s' is not defined.", fnName);
            }
            expr = new FunctionExpr(function, fnName, args);
        }
        this.nodes.put(ctx, expr);
    }

    @Override
    public void exitIdentifierExpr(ExprParser.IdentifierExprContext ctx) {
        String text = ExprListenerImpl.sanitizeIdentifierString(ctx.getText());
        this.nodes.put(ctx, this.createIdentifierExpr(text));
    }

    @Override
    public void enterLambda(ExprParser.LambdaContext ctx) {
        for (int i = 0; i < ctx.IDENTIFIER().size(); ++i) {
            String text = ctx.IDENTIFIER(i).getText();
            text = ExprListenerImpl.sanitizeIdentifierString(text);
            this.lambdaIdentifiers.add(text);
        }
    }

    @Override
    public void exitLambda(ExprParser.LambdaContext ctx) {
        ArrayList<IdentifierExpr> identifiers = new ArrayList<IdentifierExpr>(ctx.IDENTIFIER().size());
        for (int i = 0; i < ctx.IDENTIFIER().size(); ++i) {
            String text = ctx.IDENTIFIER(i).getText();
            text = ExprListenerImpl.sanitizeIdentifierString(text);
            identifiers.add(i, this.createIdentifierExpr(text));
            this.lambdaIdentifiers.remove(text);
        }
        this.nodes.put(ctx, new LambdaExpr(identifiers, (Expr)this.nodes.get(ctx.expr())));
    }

    @Override
    public void exitFunctionArgs(ExprParser.FunctionArgsContext ctx) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        for (ParseTree parseTree : ctx.expr()) {
            args.add((Expr)this.nodes.get(parseTree));
        }
        this.nodes.put(ctx, args);
    }

    @Override
    public void exitNull(ExprParser.NullContext ctx) {
        this.nodes.put(ctx, new StringExpr(null));
    }

    @Override
    public void exitStringArray(ExprParser.StringArrayContext ctx) {
        String[] values = new String[ctx.STRING().size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = ExprListenerImpl.escapeStringLiteral(ctx.STRING(i).getText());
        }
        this.nodes.put(ctx, new StringArrayExpr(values));
    }

    @Override
    public void exitEmptyArray(ExprParser.EmptyArrayContext ctx) {
        this.nodes.put(ctx, new StringArrayExpr(new String[0]));
    }

    private IdentifierExpr createIdentifierExpr(String binding) {
        if (!this.lambdaIdentifiers.contains(binding)) {
            String uniqueIdentifier = binding;
            while (this.uniqueIdentifiers.contains(uniqueIdentifier)) {
                uniqueIdentifier = StringUtils.format("%s_%s", binding, this.uniqueCounter++);
            }
            this.uniqueIdentifiers.add(uniqueIdentifier);
            return new IdentifierExpr(uniqueIdentifier, binding);
        }
        return new IdentifierExpr(binding);
    }

    private static String sanitizeIdentifierString(String text) {
        if (text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
            text = StringEscapeUtils.unescapeJava((String)text.substring(1, text.length() - 1));
        }
        return text;
    }

    private static String escapeStringLiteral(String text) {
        String unquoted = text.substring(1, text.length() - 1);
        return unquoted.indexOf(92) >= 0 ? StringEscapeUtils.unescapeJava((String)unquoted) : unquoted;
    }
}

