/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprType;
import org.apache.hive.druid.org.apache.druid.math.expr.UnaryExpr;

class UnaryNotExpr
extends UnaryExpr {
    UnaryNotExpr(Expr expr) {
        super(expr);
    }

    @Override
    UnaryExpr copy(Expr expr) {
        return new UnaryNotExpr(expr);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        ExprEval ret = this.expr.eval(bindings);
        if (NullHandling.sqlCompatible() && ret.value() == null) {
            return ExprEval.of(null);
        }
        ExprType retType = ret.type() == ExprType.DOUBLE ? ExprType.DOUBLE : ExprType.LONG;
        return ExprEval.of(!ret.asBoolean(), retType);
    }

    public String toString() {
        return StringUtils.format("!%s", this.expr);
    }
}

