/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.metadata;

import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.org.apache.druid.java.util.common.RetryUtils;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.hive.druid.org.apache.druid.metadata.RetryTransactionException;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.tweak.HandleCallback;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public abstract class SQLFirehoseDatabaseConnector {
    static final int MAX_RETRIES = 10;

    public <T> T retryWithHandle(HandleCallback<T> callback, Predicate<Throwable> myShouldRetry) {
        try {
            return (T)RetryUtils.retry(() -> this.getDBI().withHandle(callback), myShouldRetry, 10);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final boolean isTransientException(Throwable e) {
        return e != null && (e instanceof RetryTransactionException || e instanceof SQLTransientException || e instanceof SQLRecoverableException || e instanceof UnableToObtainConnectionException || e instanceof UnableToExecuteStatementException || e instanceof SQLException && this.isTransientException(e.getCause()) || e instanceof DBIException && this.isTransientException(e.getCause()));
    }

    protected BasicDataSource getDatasource(MetadataStorageConnectorConfig connectorConfig) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUsername(connectorConfig.getUser());
        dataSource.setPassword(connectorConfig.getPassword());
        String uri = connectorConfig.getConnectURI();
        dataSource.setUrl(uri);
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery(this.getValidationQuery());
        return dataSource;
    }

    public String getValidationQuery() {
        return "SELECT 1";
    }

    public abstract DBI getDBI();
}

