/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.YieldingSequenceBase;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.hive.druid.org.apache.druid.segment.SegmentMissingException;

public class RetryQueryRunner<T>
implements QueryRunner<T> {
    private static final EmittingLogger log = new EmittingLogger(RetryQueryRunner.class);
    private final QueryRunner<T> baseRunner;
    private final RetryQueryRunnerConfig config;
    private final ObjectMapper jsonMapper;

    public RetryQueryRunner(QueryRunner<T> baseRunner, RetryQueryRunnerConfig config, ObjectMapper jsonMapper) {
        this.baseRunner = baseRunner;
        this.config = config;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public Sequence<T> run(final QueryPlus<T> queryPlus, final ResponseContext context) {
        final ArrayList<Sequence<T>> listOfSequences = new ArrayList<Sequence<T>>();
        listOfSequences.add(this.baseRunner.run(queryPlus, context));
        return new YieldingSequenceBase<T>(){

            @Override
            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                List missingSegments = RetryQueryRunner.this.getMissingSegments(context);
                if (!missingSegments.isEmpty()) {
                    for (int i = 0; i < RetryQueryRunner.this.config.getNumTries(); ++i) {
                        log.info("[%,d] missing segments found. Retry attempt [%,d]", missingSegments.size(), i);
                        context.put(ResponseContext.Key.MISSING_SEGMENTS, new ArrayList());
                        QueryPlus retryQueryPlus = queryPlus.withQuerySegmentSpec(new MultipleSpecificSegmentSpec(missingSegments));
                        Sequence retrySequence = RetryQueryRunner.this.baseRunner.run(retryQueryPlus, context);
                        listOfSequences.add(retrySequence);
                        missingSegments = RetryQueryRunner.this.getMissingSegments(context);
                        if (missingSegments.isEmpty()) break;
                    }
                    List finalMissingSegs = RetryQueryRunner.this.getMissingSegments(context);
                    if (!RetryQueryRunner.this.config.isReturnPartialResults() && !finalMissingSegs.isEmpty()) {
                        throw new SegmentMissingException("No results found for segments[%s]", finalMissingSegs);
                    }
                    return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(listOfSequences)).toYielder(initValue, accumulator);
                }
                return ((Sequence)Iterables.getOnlyElement(listOfSequences)).toYielder(initValue, accumulator);
            }
        };
    }

    private List<SegmentDescriptor> getMissingSegments(ResponseContext context) {
        Object maybeMissingSegments = context.get(ResponseContext.Key.MISSING_SEGMENTS);
        if (maybeMissingSegments == null) {
            return new ArrayList<SegmentDescriptor>();
        }
        return this.jsonMapper.convertValue(maybeMissingSegments, new TypeReference<List<SegmentDescriptor>>(){});
    }
}

