/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;

public class UnionDataSource
implements DataSource {
    @JsonProperty
    private final List<TableDataSource> dataSources;

    @JsonCreator
    public UnionDataSource(@JsonProperty(value="dataSources") List<TableDataSource> dataSources) {
        Preconditions.checkNotNull(dataSources, "dataSources cannot be null for unionDataSource");
        this.dataSources = dataSources;
    }

    @Override
    public List<String> getNames() {
        return this.dataSources.stream().map(input -> Iterables.getOnlyElement(input.getNames())).collect(Collectors.toList());
    }

    @JsonProperty
    public List<TableDataSource> getDataSources() {
        return this.dataSources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionDataSource that = (UnionDataSource)o;
        return this.dataSources.equals(that.dataSources);
    }

    public int hashCode() {
        return this.dataSources.hashCode();
    }

    public String toString() {
        return "UnionDataSource{dataSources=" + this.dataSources + '}';
    }
}

