/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation;

import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.segment.BaseFloatColumnValueSelector;

public class FloatMinAggregator
implements Aggregator {
    private final BaseFloatColumnValueSelector selector;
    private float min;

    static double combineValues(Object lhs, Object rhs) {
        return Math.min(((Number)lhs).floatValue(), ((Number)rhs).floatValue());
    }

    public FloatMinAggregator(BaseFloatColumnValueSelector selector) {
        this.selector = selector;
        this.min = Float.POSITIVE_INFINITY;
    }

    @Override
    public void aggregate() {
        this.min = Math.min(this.min, this.selector.getFloat());
    }

    @Override
    public Object get() {
        return Float.valueOf(this.min);
    }

    @Override
    public float getFloat() {
        return this.min;
    }

    @Override
    public long getLong() {
        return (long)this.min;
    }

    @Override
    public double getDouble() {
        return this.min;
    }

    @Override
    public void close() {
    }
}

