/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

public class FloatSumVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;

    public FloatSumVectorAggregator(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putFloat(position, 0.0f);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        float[] vector = this.selector.getFloatVector();
        float sum = 0.0f;
        for (int i = startRow; i < endRow; ++i) {
            sum += vector[i];
        }
        buf.putFloat(position, buf.getFloat(position) + sum);
    }

    @Override
    public void aggregate(ByteBuffer buf, int numPositions, int[] positions, @Nullable int[] rows, int positionOffset) {
        float[] vector = this.selector.getFloatVector();
        for (int i = 0; i < numPositions; ++i) {
            int position = positions[i] + positionOffset;
            buf.putFloat(position, buf.getFloat(position) + vector[rows != null ? rows[i] : i]);
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return Float.valueOf(buf.getFloat(position));
    }

    @Override
    public void close() {
    }
}

